/************************************************************************
* memcmp - Compare N bytes of S1 and S2.
************************************************************************/

#include <memory.h>

int
memcmp (const void *s1, const void *s2, size_t n)
{
   char *p1 = (char *)s1;
   char *p2 = (char *)s2;

   for (; n; n--)
   {
      if (*p1 < *p2) return (-1);
      if (*p1 > *p2) return (1);
      p1++;
      p2++;
   }
   return (0);
}
