/************************************************************************
* mkdir - Make (create) a directory.
************************************************************************/

#include <stdio.h>
#include <unistd.h>
#include <errno.h>
#include <string.h>
#include <memory.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <sys/svc.h>

int
mkdir (const char *path, mode_t mode)
{
   SVCIOBlk svc;
   char filepath[MAXPATHNAMESIZE+2];


#ifdef DEBUGMKDIR
   printf ("mkdir: path = %s\n", path);
#endif

   /*
   ** Can't create on devices.
   */

   if (strchr (path, ':') != NULL)
   {
      _errno = ENOTBLK;
      return (-1);
   }

   memset (&svc, 0, sizeof(SVCIOBlk));

   /*
   ** Copy pathname and upcase
   */

   _setpath (filepath, (char *)path);

   svc.opcode = SVCIO;
   svc.subopcode = CREATEFILE;
   svc.utilityflags = UTILDIRECTORY | UTILRANDOM;
   svc.pathname = filepath;

   _issue_svc ((SVCBlk *)&svc);
   if (svc.status)
   {
#ifdef DEBUGMKDIR
   printf ("   create status = %02X\n", svc.status);
#endif
      _maperr (svc.status);
      return (-1);
   }
   
   return (0);
}
