/************************************************************************
* mktemp - Make a tempoary file name.
************************************************************************/

#include <stdlib.h>
#include <sys/types.h>
#include <sys/stdio.h>
#include <unistd.h>
#include <errno.h>

static int myserial = 0;

char *
mktemp (char *template)
{
   int i, j;
   pid_t mypid;

   _errno = 0;
   i = strlen (template) - 1;
   for (j = 0; i && template[i] == 'X'; j++, i--) ;
   if (j != 6)
   {
      _errno = EINVAL;
      return (NULL);
   }
   i++;
   mypid = getpid();
   _tempnam (&template[i], (int)mypid, myserial);
   myserial++;
   return (template);
}
