/************************************************************************
* opendir - Open a directory.
************************************************************************/

#include <stdio.h>
#include <unistd.h>
#include <stdarg.h>
#include <errno.h>
#include <memory.h>
#include <string.h>
#include <stdlib.h>
#include <fcntl.h>
#include <sys/types.h>
#include <dirent.h>
#include <sys/svc.h>

DIR *
opendir (const char *path)
{
   DIR *dp;
   FileTable *ft;
   int fd;
   SVCIOBlk svc;
   char filepath[MAXPATHNAMESIZE+2];


#ifdef DEBUGDIRIO
   printf ("opendir: path = %s\n", path);
#endif

   memset (&svc, 0, sizeof(SVCIOBlk));

   /*
   ** Copy pathname and upcase
   */

   _setpath (filepath, (char *)path);

#ifdef DEBUGDIRIO
   printf ("   filepath = %s\n", &filepath[1]);
#endif

   /*
   ** Assign luno to the file
   */

   _errno = 0;
   for (fd = __MINLUNO; fd < __MAXLUNO; fd++)
   {
      ft = &_file_table[fd];
      if (!(ft->modes & FTINUSE)) break;
   }
   if (fd == __MAXLUNO)
   {
      _errno = EMFILE;
      return (NULL);
   }

   svc.opcode = SVCIO;
   svc.luno = fd;
   svc.subopcode = ASSIGNFILE;
   svc.utilityflags = UTILDIRECTORY;
   svc.pathname = filepath;
   svc.definedlogicalrecordlength = BUFSIZ;

   _issue_svc ((SVCBlk *)&svc);
   if (svc.status)
   {
#ifdef DEBUGDIRIO
   printf ("   assign status = %02X\n", svc.status);
#endif
      _maperr (svc.status);
      return (NULL);
   }
   
   /*
   ** Open the file
   */

   svc.subopcode = OPEN;
   svc.userflags = USERREADONLY;

   _issue_svc ((SVCBlk *)&svc);
   if (svc.status)
   {
#ifdef DEBUGDIRIO
   printf ("   open status = %02X\n", svc.status);
#endif
      _maperr (svc.status);
      goto RELEASE;
   }
   ft->type = (int)svc.buffer;

   /*
   ** Read the file characteristics
   */

   svc.subopcode = READCHAR;
   svc.buffer = &ft->attrflags;
   svc.logicalrecordlength = 12;
   svc.charactercount = 12;

   _issue_svc ((SVCBlk *)&svc);
   if (svc.status)
   {
#ifdef DEBUGDIRIO
   printf ("   readchar status = %02X\n", svc.status);
#endif
      _errno = EIO;
      goto CLOSE_ALL;
   }
#ifdef DEBUGDIRIO
   printf ("   filechar: flags = %X, prl = %d, lrl = %d, nrecs = %ld\n",
           ft->attrflags, ft->physicalrecordlength, ft->logicalrecordlength,
	   ft->numberofrecords);
#endif

   if (((ft->attrflags & ATTRUSAGEMASK) != ATTRDIRECTORY) ||
	(ft->attrflags & ATTRCRLFDEVICE))
   {
      _errno = ENOTDIR;
      goto CLOSE_ALL;
   }
   if ((dp = malloc (sizeof (DIR))) == NULL)
   {
      _errno = ENOMEM;
      goto CLOSE_ALL;
   }
   ft->modes = FTINUSE;
   ft->recnum = 0;

   dp->dd_fd = fd;
   dp->dd_count = ft->numberofrecords;
   dp->dd_pos = 1;

   return (dp);

CLOSE_ALL:
   svc.subopcode = CLOSE;
   _issue_svc ((SVCBlk *)&svc);
RELEASE:
   svc.subopcode = RELEASEFILE;
   _issue_svc ((SVCBlk *)&svc);
   return (NULL);
}
