/************************************************************************
* _readbuffer - Get a line from a file into a buffer.
************************************************************************/

#include <stdio.h>
#include <unistd.h>
#include <string.h>
#include <errno.h>

int
_readbuffer (FILE *fd)
{
   int i;

#ifdef DEBUGIO
   if (fd->file_num > STDERR_FILENO)
      printf ("_readbuffer: fd = %p\n", fd);
#endif

   fd->file_pos = 0;
   fd->file_len = BUFSIZ;
   fd->file_flags &= ~(_FILE_ERROR | _FILE_EOF);
   if (fd->file_num > STDERR_FILENO)
   {
      FileTable *ft;

      ft = &_file_table[fd->file_num];
      if (ft->logicalrecordlength > 0)
	 fd->file_len = ft->logicalrecordlength;
   }

   if (fd->file_flags & _FILE_READ)
   {
      if ((i = read (fd->file_num, fd->file_buf, fd->file_len)) < 0)
      {
	 fd->file_flags |= _FILE_ERROR;
         return (-1);
      }
      else if (i == 0)
      {
	 fd->file_flags |= _FILE_EOF;
	 return (-1);
      }

      if (!(fd->file_flags & _FILE_BINARY) && (fd->file_num > STDERR_FILENO))
      {
	 char *bp = &fd->file_buf[--i];

	 /*
	 ** File text mode, trim blanks and convert to null terminated
	 */

	 while (i && *bp == ' ')
	 {
	    i--;
	    bp--;
	 }
	 i++;
	 bp++;
	 *bp++ = '\n';
	 i++;
	 *bp = '\0';
      }
#ifdef DEBUGIO
      if (fd->file_num > STDERR_FILENO)
	 printf ("   len = %d(%d)\n", fd->file_len, i);
#endif
      fd->file_len = i;
   }
   else
   {
      fd->file_flags |= _FILE_ERROR;
      return (-1);
   }
   return (0);
}
