#include <unistd.h>
#include <sgtty.h>
#include <sys/svc.h>

extern word_t _termxflag;
extern word_t _termusrflag;

int
stty (int fd, struct sgttyb *ttyb)
{
   if (isatty (fd) != 1)
      return (-1);

   if ((ttyb->sg_flags & ECHO) == 0)   
   {
      _termusrflag |= USERTERMBLK;
      _termxflag |= TERMNOECHO;
   }
   else
   {
      _termusrflag &= ~USERTERMBLK;
      _termxflag &= ~TERMNOECHO;
   }

   return (0);
}
