/************************************************************************
* telldir - Tell a location in directory.
************************************************************************/

#include <stddef.h>
#include <errno.h>
#include <sys/types.h>
#include <dirent.h>

off_t
telldir (DIR *dp)
{
   /*
   ** Ensure that DIR ptr is good.
   */

   if (dp == NULL)
   {
      _errno = EBADF;
      return (-1);
   }

   return (dp->dd_pos - 1);
}
