#include <stdlib.h>
#include <stdio.h>
#include <unistd.h>
#include <memory.h>
#include <sys/svc.h>

#include "hexdump.h"

extern char *getcmn (int *cmnlen);
extern void retcmn (void);

main (int argc, char **argv)
{
   char *cmnadr;
   int cmnlen;
   int i;
   
   printf ("%s: Dump Common: argc = %d\n", argv[0], argc);

   for (i = 1; i < argc; i++)
   {
      printf ("arg[%d] = %s\n", i, argv[i]);
   }

   if ((cmnadr = getcmn (&cmnlen)) == NULL)
   {
      fprintf (stderr, "Can't get common\n");
      return (1);
   }

   printf ("Got common: address = %p, length = %d\n", cmnadr, cmnlen);
   HEXDUMP (stdout, cmnadr, cmnlen, 0);

   retcmn ();
   return (0);
}
