#include <stdio.h>
#include <stdlib.h>
#include <unistd.h>
#include <string.h>
#include <errno.h>
#include <fcntl.h>

#include "hexdump.h"

int
main(int argc, char **argv)
{
   int fd;
   int i;
   int reclen, recnum;
   char temp[1024];
   
   printf ("%s:\n", argv[0]);

   for (i = 1; i < argc; i++)
   {
      printf ("arg[%d] = %s\n", i, argv[i]);
   }

   if (argc != 4)
   {
      printf ("usage: %s filein reclen recnum\n", argv[0]);
      exit(1);
   }

   reclen = atoi (argv[2]);
   recnum = atoi (argv[3]);

   if ((fd = open (argv[1], O_RDONLY)) < 0)
   {
      perror ("open failed");
      exit(1);
   }

   if (lseek (fd, recnum*reclen, SEEK_SET) == (off_t)-1)
   {
      perror ("lseek failed");
      exit(1);
   }

   if (read (fd, temp, reclen) < 0)
   {
      perror ("read failed");
      exit(1);
   }

   HEXDUMP (stdout, temp, reclen, 0);
   close (fd);

   exit(0);
}
