#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <errno.h>
#include <fcntl.h>

#include "hexdump.h"

int
main(int argc, char **argv)
{
   FILE *fd;
   int i;
   int reclen, recnum;
   char temp[1024];
   
   printf ("%s:\n", argv[0]);

   for (i = 1; i < argc; i++)
   {
      printf ("arg[%d] = %s\n", i, argv[i]);
   }

   if (argc != 4)
   {
      printf ("usage: %s filein reclen recnum\n", argv[0]);
      exit(1);
   }

   reclen = atoi (argv[2]);
   recnum = atoi (argv[3]);

   if ((fd = fopen (argv[1], "rb")) < 0)
   {
      perror ("open failed");
      exit(1);
   }

   if (fseek (fd, recnum*reclen, SEEK_SET) < 0)
   {
      perror ("fseek failed");
      exit(1);
   }

   if (fread (temp, 1, reclen, fd) == 0)
   {
      perror ("read failed");
      exit(1);
   }

   HEXDUMP (stdout, temp, reclen, 0);

   i = ftell (fd);
   printf ("ftell: %d\n", i);

   fclose (fd);

   exit(0);
}
