#include <stdio.h>
#include <unistd.h>
#include <string.h>
#include <errno.h>
#include <fcntl.h>

int
main(int argc, char **argv)
{
   int ifd, ofd;
   int i;
   char temp[82];
   
   printf ("%s:\n", argv[0]);

   for (i = 1; i < argc; i++)
   {
      printf ("arg[%d] = %s\n", i, argv[i]);
   }

   if (argc != 3)
   {
      printf ("usage: %s filein fileout\n", argv[0]);
      return 1;
   }

   if ((ifd = open (argv[1], O_RDONLY)) < 0)
   {
      printf ("open-r failed: %s: errno = %d\n", argv[1], errno);
      return 1;
   }
   if ((ofd = open (argv[2], O_WRONLY | O_CREAT)) < 0)
   {
      printf ("open-w failed: %s: errno = %d\n", argv[2], errno);
      close (ifd);
      return 1;
   }

   while ((i = read (ifd, temp, 80)) > 0)
   {
      if (write (ofd, temp, i) < 0)
      {
	 printf ("write failed: errno = %d\n", errno);
	 break;
      }
   }
   if (i < 0)
   {
      printf ("read failed: errno = %d\n", errno);
   }

   close (ifd);
   close (ofd);

   return 0;
}
