#include <stdio.h>
#include <unistd.h>
#include <string.h>
#include <errno.h>
#include <fcntl.h>

#ifdef DEBUGIO
#include "hexdump.h"
#endif

int
main(int argc, char **argv)
{
   FILE *ifd, *ofd;
   int i;
   char temp[82];
   
   printf ("%s:\n", argv[0]);

   for (i = 1; i < argc; i++)
   {
      printf ("arg[%d] = %s\n", i, argv[i]);
   }

   if (argc != 3)
   {
      printf ("usage: %s filein fileout\n", argv[0]);
      return 1;
   }

   if ((ifd = fopen (argv[1], "r")) == NULL)
   {
      printf ("fopen-r failed: %s: %s\n", argv[1], strerror(errno));
      return 1;
   }
   if ((ofd = fopen (argv[2], "w")) == NULL)
   {
      printf ("fopen-w failed: %s: %s\n", argv[2], strerror(errno));
      fclose (ifd);
      return 1;
   }

   while (fgets (temp, 80, ifd))
   {
#ifdef DEBUGIO
      HEXDUMP (stdout, temp, 82, 0);
#endif
      fputs (temp, ofd);
   }
   if (ferror(ifd))
   {
      printf ("fgets failed\n");
   }

   fclose (ifd);
   fclose (ofd);

   return 0;
}
