#include <stdio.h>
#include <stdlib.h>
#include <unistd.h>
#include <sys/svc.h>

extern Malloc_blk *_heapbottom;

static int
dumpblks(void)
{
   Malloc_blk *cp;

   for (cp = _heapbottom; cp; cp = cp->next)
   {
      printf (
	 "   blk >%04X, size = %4u, flags = %d, back = >%04X, next = >%04X\n",
	       (unsigned)cp, cp->size, cp->flags,
	       (unsigned)cp->back, (unsigned)cp->next);
   }
   return 0;
}

int
main(int argc, char **argv)
{
   char *ma[40];
   int num, size;
   int i;
   
   num = 3;
   size = 248;
   printf ("%s: num = %d, size = %d\n",
	    argv[0], num, size);

   dumpblks();

   for (i = 0; i < num; i++)
   {
      ma[i] = (char *)malloc (size);
      if (!ma[i])
      {
	 num = i;
	 break;
      }
      printf ("   alloc ma[%d] = >%04X\n", i, (unsigned)ma[i]);
      dumpblks();
   }
   puts ("\n");

   i = 1;
   printf ("   free ma[%d] = >%04X\n", i, (unsigned)ma[i]);
   free (ma[i]);
   dumpblks();

   ma[i] = (char *)malloc (120);
   printf ("   alloc ma[%d] = >%04X\n", i, (unsigned)ma[i]);
   dumpblks();
   puts ("\n");

   for (i = 0; i < num; i++)
   {
      printf ("   free ma[%d] = >%04X\n", i, (unsigned)ma[i]);
      if (!ma[i]) break;
      free (ma[i]);
      dumpblks();
   }

   puts ("\n   termination\n");
   dumpblks();

   return 0;
}
