#include <stdio.h>
#include <stdlib.h>
#include <unistd.h>
#include <sys/svc.h>

int
main(int argc, char **argv)
{
   unsigned int secs;
   SVCDate svc;
   
   if (argc != 2)
   {
      printf ("usage: %s time\n", argv[0]);
      return 1;
   }

   secs = atoi (argv[1]);
   printf ("%s: time = %d secs\n", argv[0], secs);

   svc.opcode = SVCDATE;
   svc.status = 0;
   svc.datblk = (char *)&svc.year;
   svc.hour = 0;
   svc.minute = 0;
   svc.second = 0;

   _issue_svc ((SVCBlk *)&svc);
   printf ("start: %d:%02d:%02d\n", svc.hour, svc.minute, svc.second);

   sleep (secs);

   _issue_svc ((SVCBlk *)&svc);
   printf ("stop: %d:%02d:%02d\n", svc.hour, svc.minute, svc.second);

   return 0;
}
