/************************************************************************
* tmpfile - Open/create a temporary file.
************************************************************************/

#include <stdio.h>
#include <stdlib.h>

static int
gthex (int ch)
{
   ch -= 0x30;
   if (ch > 9) ch -= 7;
   return (ch);
}

FILE *
tmpfile (void)
{
   FILE *fd;
   char path[10];

   strcpy (path, ".TMXXXXXX");
   if (mktemp (path) == NULL)
      return (NULL);
   if ((fd = fopen (path, "wb")) != NULL)
   {
      int seq = (gthex(path[7]) << 4) | gthex(path[8]);
      fd->file_flags |= _FILE_TEMP;
      fd->file_flags |= (seq <<  8);
   }
   return (fd);
}
