/************************************************************************
* opendir - Open a directory.
************************************************************************/

#include <stdio.h>
#include <unistd.h>
#include <string.h>
#include <errno.h>
#include <fcntl.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <sys/svc.h>
#include <dirent.h>

#if defined(DEBUGDIRIO) || defined(DEBUGSTAT)
#include "hexdump.h"
#endif

#ifndef MAXPATHNAMESIZE
#define MAXPATHNAMESIZE 255
#endif

#if !defined(dx10) && !defined(dnos)
#define d_flags d_ino
#endif

DIR *
opendir (const char *path)
{
   DIR *dp;
   FileTable *ft;
   SVCIODDisk *dsksvc;
   int fd;
   SVCIOBlk svc;
   int stats[16];
   char filepath[MAXPATHNAMESIZE+2];

#ifdef DEBUGDIRIO
   printf ("txopendir: path = %s\n", path);
#endif

   bzero (&svc, sizeof(SVCIOBlk));

   svc.opcode = SVCSETPRV;
   _issue_svc ((SVCBlk *)&svc);

   /*
   ** Copy pathname and upcase
   */

   _setpath (filepath, (char *)path);

   /*
   ** Assign luno to the file
   */

   _errno = 0;
   for (fd = __MINLUNO; fd < __MAXLUNO; fd++)
   {
      ft = &_file_table[fd];
      if (!(ft->modes & FTINUSE)) break;
   }
   if (fd == __MAXLUNO)
   {
      _errno = EMFILE;
      return (NULL);
   }

   svc.opcode = SVCIO;
   svc.luno = fd;
   svc.subopcode = ASSIGNFILE;
   svc.utilityflags = 0x1080;
   svc.pathname = filepath;

   _issue_svc ((SVCBlk *)&svc);
#ifdef DEBUGDIRIO
   HEXDUMP (stdout, (char *)&svc, sizeof(SVCIOBlk), 0);
#endif
   if (svc.status)
   {
#ifdef DEBUGDIRIO
   printf ("   assign status = %02X\n", svc.status);
#endif
      _maperr (svc.status);
      return (NULL);
   }
   
   /*
   ** Open the file
   */

   dsksvc = (SVCIODDisk *)&svc;
   dsksvc->subopcode = OPEN;
   dsksvc->sectorrecord = 1;
   dsksvc->sectoraddress = 6;

   _issue_svc ((SVCBlk *)dsksvc);
#ifdef DEBUGDIRIO
   HEXDUMP (stdout, (char *)dsksvc, sizeof(SVCIOBlk), 0);
#endif
   if (dsksvc->status)
   {
#ifdef DEBUGDIRIO
   printf ("   open status = %02X\n", dsksvc->status);
#endif
      _maperr (dsksvc->status);
      goto RELEASE;
   }

   /*
   ** Read the device characteristics
   */

   dsksvc->subopcode = DEVICECHAR;
   dsksvc->userflags = 1;
   dsksvc->buffer = &stats;
   dsksvc->logicalrecordlength = 22;
   dsksvc->charactercount = 22;

   _issue_svc ((SVCBlk *)dsksvc);
#ifdef DEBUGDIRIO
   HEXDUMP (stdout, (char *)dsksvc, sizeof(SVCIOBlk), 0);
#endif
   if (dsksvc->status)
   {
#ifdef DEBUGDIRIO
   printf ("   readchar status = %02X\n", dsksvc->status);
#endif
      _errno = EIO;
      goto CLOSE_ALL;
   }
#ifdef DEBUGDIRIO
   printf ("   filechar: \n");
   HEXDUMP (stdout, (char *)&stats, 28, 0);
#endif

   if ((dp = malloc (sizeof (DIR))) == NULL)
   {
      _errno = ENOMEM;
      goto CLOSE_ALL;
   }
   ft->modes = FTINUSE;
   ft->type = (int)svc.buffer;
   ft->recnum = 0;

   dp->dd_fd = fd;
   dp->dd_count = TXDIRPSEC * TXSECAU;
   dp->dd_pos = 0;
   dp->dd_sec = (off_t)-1;

   return (dp);

CLOSE_ALL:
   svc.subopcode = CLOSE;
   _issue_svc ((SVCBlk *)&svc);
RELEASE:
   svc.subopcode = RELEASEFILE;
   _issue_svc ((SVCBlk *)&svc);
   return (NULL);
}
