/************************************************************************
* stat - Stat a file.
************************************************************************/

#include <stdio.h>
#include <unistd.h>
#include <string.h>
#include <errno.h>
#include <fcntl.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <sys/svc.h>
#include <dirent.h>

#if defined(DEBUGDIRIO) || defined(DEBUGSTAT)
#include "hexdump.h"
#endif

#ifndef MAXPATHNAMESIZE
#define MAXPATHNAMESIZE 255
#endif

#if !defined(dx10) && !defined(dnos)
#define d_flags d_ino
#endif

int
stat (const char *path, struct stat *buf)
{
   DIR *dp;
   struct dirent *ep;
   char *fn;
   char *cp;
   int found;
   char temp[MAXPATHNAMESIZE+2];
   char file[MAXPATHNAMESIZE+2];

   if (buf == NULL)
   {
      _errno = EINVAL;
      return (-1);
   }

   bzero (buf, sizeof(struct stat));
   strcpy (temp, path);
   if ((fn = strrchr (temp, ':')) == NULL)
   {
      buf->st_mode = S_IFBLK;
      return (0);
   }

   *fn++ = 0;
   for (cp = fn; *cp; cp++)
      if (*cp >= 'a' && *cp <= 'z') *cp -= 0x20;
   strcpy (file, fn);
   fn = file;

#ifdef DEBUGSTAT
   printf ("stat: path = %s, temp = %s, fn = %s\n", path, temp, fn);
#endif
   if ((dp = opendir (temp)) == NULL)
   {
      return (-1);
   }
   found = FALSE;
   while ((ep = readdir(dp)) != NULL)
   {
#ifdef DEBUGSTAT
      printf ("   ep->d_name = %s\n", ep->d_name);
#endif
      if (!strcmp (fn, ep->d_name))
      {
	 found = TRUE;
	 buf->st_mode = S_IRUSR | S_IRGRP | S_IROTH;
	 buf->st_mode |= S_IFREG;
	 buf->st_size = ep->d_size;
	 if (ep->d_flags)
	    buf->st_mode |= S_IWUSR | S_IWGRP | S_IWOTH;
         break;
      }
   }
   closedir (dp);
   if (!found)
   {
      _errno = ENOENT;
      return (-1);
   }
   return (0);
}
