/************************************************************************
* unlink - Delete a file.
************************************************************************/

#include <stdio.h>
#include <unistd.h>
#include <stdarg.h>
#include <errno.h>
#include <memory.h>
#include <string.h>
#include <fcntl.h>
#include <sys/svc.h>

int
unlink (const char *path)
{
   SVCIOBlk svc;
   char filepath[MAXPATHNAMESIZE+2];


#ifdef DEBUGIO
   printf ("unlink: path = %s\n", path);
#endif

   memset (&svc, 0, sizeof(SVCIOBlk));

   /*
   ** Copy pathname and upcase
   */

   _setpath (filepath, (char *)path);

   /*
   ** Delete the file
   */

   _errno = 0;

   svc.opcode = SVCIO;
   svc.luno = 0;
   svc.subopcode = DELETEFILE;
   svc.utilityflags = 0;
   svc.pathname = filepath;

   _issue_svc ((SVCBlk *)&svc);
   if (svc.status)
   {
      _maperr(svc.status);
      return (-1);
   }
   
   return (0);
}
