/************************************************************************
* vsprintf - Print a formatted line into a buffer.
************************************************************************/

#include <stddef.h>
#include <stdio.h>
#include <string.h>
#include <stdarg.h>
#include <memory.h>

extern char *_cvtdec (int, char *, int, int, int);
extern char *_cvthexoct (int, char *, int, int, int, int);
extern char *_cvtdec32 (long *, char *, int, int, int);
extern char *_cvthexoct32 (long *, char *, int, int, int, int);

#ifndef MINLIB
extern char *_cvtexp (double *, char *, int);
extern char *_cvtfloat (double *, char *, int, int);
#endif

int
vsprintf (char *obuf, const char *fmt, va_list *arg)
{
   double fnum;
   long lnum;
   char *fp;
   char *op;
   char *s;
   va_list ap;
   int done;
   int longflag;
   int signval;
   int bighex;
   int num;
   int octflag;

   memcpy ((void*)&ap, (void*)&arg, sizeof(va_list));
   fp = (char *)fmt;
   op = obuf;
   *op = 0;

   while (*fp)
   {
      if (*fp == '%')
      {
	 int fill;
	 int len;
	 int first;
	 int digits;
	 int chars;
	 int prec;

         fp++;
	 bighex = FALSE;
	 longflag = FALSE;
	 done = FALSE;
	 prec = FALSE;
	 octflag = FALSE;
	 len = 0;
	 chars = 0;
	 signval = TRUE;
	 first = TRUE;
	 fill = ' ';
	 digits = 6;

	 while (!done)
	 {
	    if (*fp >= '0' && *fp <= '9')
	    {
	       if (first && *fp == '0')
		  fill = *fp++;
	       else if (prec)
		  digits = (digits * 10) + (*fp++ - '0');
	       else
		  len = (len * 10) + (*fp++ - '0');
	       first = FALSE;
	    }
	    else if (*fp == '%')
	    {
	       *op++ = '%';
	       *op = 0;
	       fp++;
	       done = TRUE;
	    }
	    else if (*fp == '.')
	    {
	       prec = TRUE;
	       digits = 0;
	       fp++;
	    }
	    else switch (*fp)
	    {
#ifndef MINLIB
	    case 'e':
	       fp++;
	       fnum = va_arg (ap, double);
	       op = _cvtexp (&fnum, op, digits);
	       done = TRUE;
	       break;

	    case 'f':
	       fp++;
	       fnum = va_arg (ap, double);
	       if (len == 0) len = 8;
	       op = _cvtfloat (&fnum, op, len, digits);
	       done = TRUE;
	       break;
#endif

	    case 'l':
	       fp++;
	       longflag = TRUE;
	       break;

	    case 'c':
	       fp++;
	       num = va_arg (ap, int);
	       *op++ = num;
	       *op = 0;
	       done = TRUE;
	       break;
	       
	    case 'u':
	       signval = FALSE;
	    case 'd':
	    case 'i':
	       fp++;
	       if (longflag)
	       {
		  lnum = va_arg (ap, long);
		  op = _cvtdec32 (&lnum, op, signval, len, fill);
	       }
	       else
	       {
		  num = va_arg (ap, int);
		  op = _cvtdec (num, op, signval, len, fill);
	       }
	       done = TRUE;
	       break;

	    case 's':
	       fp++;
	       s = va_arg (ap, char *);
	       strcat (op, s);
	       while (*op)
	       {
		  op++;
		  chars++;
	       }
	       if (chars < len)
	       {
		  for (; chars < len; chars++)
		     *op++ = ' ';
		  *op = 0;
	       }
	       done = TRUE;
	       break;

	    case 'o':
	       octflag = TRUE;
	    case 'X':
	       bighex = TRUE;
	    case 'p':
	    case 'x':
	       fp++;
	       if (longflag)
	       {
		  lnum = va_arg (ap, long);
		  op = _cvthexoct32 (&lnum, op, bighex, octflag, len, fill);
	       }
	       else
	       {
		  num = va_arg (ap, int);
		  op = _cvthexoct (num, op, bighex, octflag, len, fill);
	       }
	       done = TRUE;
	       break;

	    default:
	       fp++;
	       done = TRUE;
	    }
	 }
      }
      else
      {
         *op++ = *fp++;
	 *op = 0;
      }
   }
   *op = *fp;
   va_end (ap);

   return (strlen(obuf));
}
