/************************************************************************
* write - Write to a file.
************************************************************************/

#include <unistd.h>
#include <errno.h>
#include <memory.h>
#include <sys/svc.h>

int
write (int fd, const void *buffer, int count)
{
   FileTable *ft;
   SVCIOBlk svc;

   _errno = 0;

   /*
   ** If stdout or stderr, print it
   */

   if (fd <= STDERR_FILENO)
      return (_printline (fd, buffer, count));

   memset (&svc, 0, sizeof (SVCIOBlk));

   if (fd >= __MAXLUNO)
   {
      _errno = EBADF;
      return (-1);
   }
   ft = &_file_table[fd];
   if (!(ft->modes & FTINUSE))
   {
      _errno = EBADF;
      return (-1);
   }

#ifdef DEBUGIO
   printf ("write: buffer = %p, count = %d\n", buffer, count);
#endif

   /*
   ** Write it out
   */

   svc.opcode = SVCIO;
   svc.subopcode = WRITEASCII;
   svc.luno = fd;
   svc.buffer = (void *)buffer;
   svc.logicalrecordlength = count;
   svc.charactercount = count;
   svc.recnum = ft->recnum;
   ft->recnum ++;

   _issue_svc ((SVCBlk *)&svc);
   if (svc.status)
   {
      _errno = EIO;
      count = -1;
   }

   return (count);
}
