/************************************************************************
* _writebuffer - Write a buffer in the file.
************************************************************************/

#include <stdio.h>
#include <unistd.h>
#include <string.h>
#include <errno.h>
#include <sys/svc.h>

int
_writebuffer (FILE *fd)
{
   int len = fd->file_pos;

#ifdef DEBUGIO
   if (fd->file_num > STDERR_FILENO)
      printf ("_writebuffer: fd = %p, len = %d\n", fd, len);
#endif

   fd->file_pos = 0;
   if (fd->file_flags & _FILE_WRITE)
   {
      if (!(fd->file_flags & _FILE_BINARY))
      {
	 FileTable *ft;

	 ft = &_file_table[fd->file_num];
	 fd->file_buf[len] = 0;

	 /*
	 ** Convert file buffer from null terminated to blank expanded
	 */

	 if (fd->file_num > STDERR_FILENO)
	 {
	    char *bp;
	    int i;
	    int mapcr;

	    mapcr = FALSE;
	    /* If Terminal or printer, map to CR/LF */
	    if (ft->attrflags & ATTRCRLFDEVICE)
	       mapcr = TRUE;
	    else if (ft->logicalrecordlength > 0)
	       len = ft->logicalrecordlength;

	    bp = fd->file_buf;
	    i = 0;
	    while (*bp)
	    {
	       if (*bp == '\n')
	       {
		  if (mapcr)
		  {
		     *bp++ = '\r';
		     *bp++ = '\n';
		     *bp = 0;
		     len += 2;
		  }
		  break;
	       }
	       i++;
	       bp++;
	    }
	    if (!mapcr)
	       for (; i < len; i++) *bp++ = ' ';
	 }
      }
      if (write (fd->file_num, fd->file_buf, len) < 0)
      {
	 fd->file_flags |= _FILE_ERROR;
         return (-1);
      }
   }
   else
   {
      fd->file_flags |= _FILE_ERROR;
      return (-1);
   }
   return (0);
}
