/************************************************************************
* access - Check files access.
************************************************************************/

#include <sys/types.h>
#include <sys/stat.h>
#include <unistd.h>
#include <errno.h>

int
access (const char *path, int mode)
{
   struct stat buf;

   if (stat (path, &buf) < 0)
      return (-1);

   if ((mode & R_OK) && !(buf.st_mode & S_IRUSR))
   {
      errno = EACCES;
      return (-1);
   }
   if ((mode & W_OK) && !(buf.st_mode & S_IWUSR))
   {
      errno = EACCES;
      return (-1);
   }
   if ((mode & X_OK) && !(buf.st_mode & S_IXUSR))
   {
      errno = EACCES;
      return (-1);
   }
   return (0);
}
