/************************************************************************
* closedir - Close a directory.
************************************************************************/

#include <unistd.h>
#include <stdarg.h>
#include <errno.h>
#include <memory.h>
#include <stdlib.h>
#include <sys/types.h>
#include <dirent.h>
#include <sys/svc.h>

int
closedir (DIR *dp)
{
   FileTable *ft;
   int status;
   int fd;
   SVCIOBlk svc;

   /*
   ** Ensure that DIR ptr is good.
   */

   if (dp == NULL)
   {
      _errno = EBADF;
      return (-1);
   }

   memset (&svc, 0, sizeof(SVCIOBlk));
   fd = dp->dd_fd;
   free (dp);
   ft = &_file_table[fd];
   _errno = 0;
   status = 0;

   /*
   ** Close file
   */

   svc.opcode = SVCIO;
   svc.subopcode = CLOSE;
   svc.luno = fd;
   _issue_svc ((SVCBlk *)&svc);
   if (svc.status)
   {
      _errno = EIO;
      status = -1;
   }

   /*
   ** Release file luno
   */

   svc.subopcode = RELEASEFILE;
   _issue_svc ((SVCBlk *)&svc);

   ft->modes = 0;

   return (status);
}
