	IDT	'CRT0SA'
	TITL	'CRT0SA - C runtime entry'
***********************************************************************
*
*   CRT0 - Set up the C runtime environment and call the C main
*            routines. Standalone version.
*
***********************************************************************
	OPTION	DUNLST,BUNLST,TUNLST
	LREF	_main
	LREF	__flushall
	REF	PGMEND
	REF	STKSIZ,HEPSIZ
*
	LDEF	__stkoverflow,__stkbottom,__stktop
	LDEF	__heapoverflow,__heapbottom,__heaptop
	LDEF	__printline,__readline,__readchar
	LDEF	__issue_svc,__errno,__curluno
	LDEF	__file_table, __file_list
	LDEF	__mapsyn
	LDEF	_stdin,_stdout,_stderr
	LDEF	_abort,_exit,_atexit
	LDEF	__istxds,__termxflag,__termusrflag
	LDEF	__sighan
*
* Terminal CRU bits
*
TRMCRU	EQU	>0		Terminal device address
XMIT	EQU	8
DTR	EQU	9
RTS	EQU	10
WRQ	EQU	11
RRQ	EQU	12
NSF	EQU	13
*
STRTLUN	EQU	0		Starting luno.
MAXLUNO	EQU	1		Maximum luno.
BUFSIZ	EQU	80
*
MAINPC	EQU	$
	LWPI	MAINWS		Set our workspace
	LI	R1,>340
	CLR	R2
IDLLOP	MOV	R1,*R2+
	CI	R2,>A0
	JNE	IDLLOP
	LI	R9,PGMEND	Get the end of the program
	MOV	R9,@__stkbottom	Set as our stack bottom
	MOV	R9,R10
	AI	R9,STKSIZ	Add stack size
	MOV	R9,@__stktop	Set as stack top
	MOV	R9,@__heapbottom and as heap bottom
	MOV	R9,R11
	LI	R12,HEPSIZ
	A	R12,R9		Add size of heap
	MOV	R9,@__heaptop	Set as heap top
	MOV	R12,*R11+	Set up heap for malloc.
	CLR	*R11+		   Flags.
	CLR	*R11+		   Back.
	CLR	*R11+		   Next.
*
	LI	R1,ENTARGV	Get the args from the user.
	BL	@WRTMSG		
	LI	R1,ARGBUF
	BL	@READMSG
	LI	R1,OPNMSG
	BL	@WRTMSG
*
	MOV	R10,R11		Set up call stack.
	MOV	R10,R12
	LI	R2,DUMSTG	dummy program name.
	MOV	R2,*R12+	push
	BL	@SETARGV	Push argv[n]
	MOV	R12,R1		End of argv list starts parms.
	MOV	R12,R11
	MOV	R2,*R11+	push argc
	MOV	R10,*R11+	push pointer to pointer argv[0]
	LI	R12,_main	Call the main program
	BLWP	R11
*
_abort
EXITPC	EQU	$
	LI	R12,__flushall
	BLWP	R11
*
EXIT	EQU	$
	IDLE			End of task
*
__stkoverflow
	LI	R1,STKOVER
	BL	@WRTMSG		Stack overflow.
	JMP	EXIT
__heapoverflow
	LI	R1,HEPOVER
	BL	@WRTMSG		Heap overflow.
	JMP	EXIT
*
_exit
	MOV	@efunc,R12	If we have an atexit func.
	JEQ	EXITPC
	BLWP	R11		Do it.
	JMP	EXITPC
_atexit
	MOV	@2(R13),R1
	MOV	*R1,@efunc
	RTWP
*
WRTMSG	MOV	*R1+,R0		Get message length
	LI	R12,TRMCRU
	SBO	DTR		Enable terminal ready
	SBO	RTS
WRT010	LDCR	*R1+,8		Send out a character
	TB	WRQ		Wait until done
	JNE	$-2
	SBZ	WRQ
	DEC	R0
	JGT	WRT010
	RT
*
READMSG	MOV	*R1+,R6		Get buffer size.
	MOV	R1,R7		Get buffer address.
	MOV	R11,R8		Stash return address.
	CLR	R5		Character count.
REA010  BL	@READCH
	CB	R0,@BS		If a BS or Delete
	JEQ	REA050		  go erase input.
	CB	R0,@DEL
	JEQ	REA040
	CB	R0,@CR		If a CR then, exit.
	JEQ	REAXIT
	MOVB	R0,*R7+		Save char into buffer.
	INC	R5
	DEC	R6
	JGT	REA010
REAXIT	DECT	R1		Point to buffer size and
	MOV	R5,*R1		   save number of chars read.
	MOV	R5,R0
	B	*R8
REA040	EQU	$
	MOVB	@BS,R0
REA050	EQU	$
	MOV	R5,R5		Don't BS if at beginning of buffer.
	JEQ	REA010
	BL	@OUTCH		Write out a BS.
	MOVB	@ABLNK,R0	Blank the char.
	BL	@OUTCH
	MOVB	@BS,R0
	BL	@OUTCH
	DEC	R7
	DEC	R5
	INC	R6
	JMP	REA010
*
efunc	DATA	0		atexit() function address.
__istxds
	DATA	0
__errno
	DATA	0		errno.
__stkbottom
	DATA	0		Bottom of stack
__stktop
	DATA	0		Top of stack
__heapbottom
	DATA	0		Bottom of heap
__heaptop
	DATA	0		Top of heap
__file_list
	DATA	_stdin0		FILE list
_stdin
	DATA	_stdin0
_stdout
	DATA	_stdout0
_stderr
	DATA	_stderr0
*
OPNMSG  DATA	2
CR	BYTE	>0D,>0A
LF	EQU	$-1
	EVEN
STKOVER	DATA	STKOVL
	TEXT	'Stack overflow, terminating'
	BYTE	>0D,>0A
STKOVL	EQU	$-STKOVER-2
__curluno
	BYTE	STRTLUN		Current luno for file alloc.
	EVEN
HEPOVER	DATA	HEPOVL
	TEXT	'Heap overflow, terminating'
	BYTE	>0D,>0A
HEPOVL	EQU	$-HEPOVER-2
	EVEN
ENTARGV	DATA	ENTARGL
	TEXT	'Enter program args: '
ENTARGL	EQU	$-ENTARGV-2
	EVEN
ABLNK	BYTE	' '
AA	BYTE	'A'
AZ	BYTE	'Z'
BS	BYTE	>08
DEL	BYTE	>7F
DUMSTG	TEXT	'saprog'
	BYTE	0
	EVEN
*
*
MAINWS	BSS	32
*
* Issue SVC to the system.
*
__issue_svc
	STWP	R11		Get WS addressability.
	AI	R11,32
	MOV	@2(R13),R1	Get SVC block pointer.
	MOV	*R1,R1
	LI	R2,>100
	MOVB	R2,@1(R1)	Standalone doesn't support SVC.
	RTWP
*
* Print string buffer to output device
*
__printline
	STWP	R11
	AI	R11,32
	MOV	@2(R13),R1	Get parameter list address
	MOV	*R1+,R2		Get file descriptor
	MOV	*R1+,R3		Get string address
	MOV	*R1+,R5		Get string length
	MOV	R11,R12		Copy buffer and set length
	INCT	R12
	CLR	R4
OUT010	EQU	$
	MOVB	*R3+,R0
	JEQ	OUT020
	CB	R0,@LF		If we have a LF, copy a CR
	JNE	OUT015
	MOVB	@CR,*R12+
	INC	R4
OUT015	EQU	$
	MOVB	R0,*R12+
	INC	R4
OUT020	EQU	$
	DEC	R5
	JGT	OUT010
	MOV	R4,*R11		Write it out
	MOV	R11,R1
	BL	@WRTMSG
	RTWP
*
* Read a line from the input device
*
READCH	EQU	$
	LI	R12,TRMCRU
	SBO	DTR		Enable terminal ready
	SBO	RTS
	TB	RRQ		Wait till we get hit
	JNE	$-2
	STCR	R0,8		Store the character
	SBZ	RRQ
	CB	R0,@BS		If a BS or Delete
	JEQ	READC1		  Don't echo.
	CB	R0,@DEL
	JEQ	READC1
OUTCH	EQU	$
	LDCR	R0,8		Echo out a character
	TB	WRQ		Wait until done
	JNE	$-2
	SBZ	WRQ
READC1	EQU	$
	RT
__termusrflag
__termxflag
	DATA    0
*
* Read a line
*
__readline
	STWP	R10
	AI	R10,32
	MOV	@2(R13),R1	Get parameter list address
	MOV	*R1+,R2		Get file descriptor
	MOV	*R1+,R3		Get buffer address
	MOV	*R1,R4		Get buffer length
	MOV	R10,R1		Buffer into the end of the frame.
	MOV	R4,*R10+	Put size into frame.
	BL	@READMSG
	MOV	R0,R5		How much did we read?
	JEQ	READ20
READ10	EQU	$
	MOVB	*R10+,*R3+	Move char to user buffer.
	DEC	R5
	JGT	READ10
READ20	EQU	$
	MOVB	@LF,*R3+
	SB	*R3,*R3
	INC	R0
	MOV	R0,*R13
	LI	R1,OPNMSG
	BL	@WRTMSG
	RTWP
*
* Read a character
*
__readchar
	STWP	R11
	AI	R11,32
	MOV	@2(R13),R1	Get parameter list address
	MOV	*R1+,R2		Get file descriptor
	BL	@READCH		Get a character
	SRL	R0,8
	MOV	R0,*R13
	RTWP
*
* Set argv pointers into stack.
*
SETARGV	EQU	$
	LI	R2,1		Set start for argv[0].
	MOV	@ARGBUF,R4	Get argv parms length.
	JEQ	SETXIT		If zero, exit
	LI	R5,ARGMSG
SET005	MOV	R5,*R12+	Push argv[n] pointer.
	INC	R2		Bump argc count.
SET010	MOVB	*R5,R13		Get char
	CB	@ABLNK,R13	BlanK?
	JEQ	SET020		Yes, end of arg.
	CB	R13,@AA		No, Convert to lower case.
	JLT	SET015
	CB	R13,@AZ
	JGT	SET015
	AB	@ABLNK,*R5
SET015	INC	R5		bump pointer.
	DEC	R4		At end?
	JEQ	SET030		Yes, exit
	JMP	SET010		No, check next.
SET020	SB	*R5,*R5		Blank, set null.
	INC	R5		Bump pointer.
	DEC	R4		At end?
	JEQ	SETXIT		Yes, exit.
	CB	@ABLNK,*R5	No, still blank?
	JEQ	SET020		Yes, set it null.
	JMP	SET005		No, start of new arg.
SET030	SB	*R5,*R5		Set trailing null.
SETXIT	RT
*
* _mapsyn - Map synonyms (no-op)
*
__mapsyn
	STWP	R10		Get WS addressability.
	AI	R10,32
	MOV	@2(R13),R1	Get parm pointer.
	MOV	*R1+,R2		Get out file descriptor.
	MOV	*R1+,R3		Get in file descriptor.
	MOVB	*R3+,R4		Get in length
	MOVB	R4,*R2+
	SRL	R4,8
	JEQ	MAP020
MAP010	MOVB	*R3+,*R2+	Move it.
	DEC	R4
	JGT	MAP010
	SB	*R2,*R2		Null terminate.
MAP020	CLR	*R13
	RTWP
*
__sighan
	DATA	0
*
_stdin0
	DATA	_stdout0
	DATA	0
	DATA	>0001
	DATA	0
	DATA	0
	DATA	_stdinbuf
_stdout0
	DATA	_stderr0
	DATA	1
	DATA	>0002
	DATA	0
	DATA	0
	DATA	_stdoutbuf
_stderr0
	DATA	0
	DATA	2
	DATA	>0002
	DATA	0
	DATA	0
	DATA	_stderrbuf
*
ARGBUF	DATA	80
ARGMSG	EQU	$
__file_table
	BSS	18
__file_table_end
*
_stdinbuf
	BSS	BUFSIZ+2
_stdoutbuf
	BSS	BUFSIZ+2
_stderrbuf
	BSS	BUFSIZ+2
	END	MAINPC
