	IDT	'CVTFLT'
	TITL	'CVTFLT - Convert floating point numbers'
***********************************************************************
*
*   CVTFLT - Converts floating point numbers into strings.
*
***********************************************************************
	OPTION	DUNLST,BUNLST,TUNLST
*
	COPY	'config.cpy'
*
	LDEF	__cvtexp,__cvtfloat
*
	ASMIF	STKCHK=1
	LREF	__stkoverflow,__stktop
	ASMEND
*
	REF	F$RITP
	LOAD	F$XLD
	LOAD	F$XMD
	LOAD	F$XDD
	LOAD	F$XSD
	LOAD	F$XSTD
	LOAD	F$XCDE
	LOAD	F$XCED
*
* Convert float number to E notation.
*
* char *_cvtexp (double *num, char *stg, int len)
*
__cvtexp
* function prologue 
	STWP	R10
	AI	R10,32
BLANK	EQU	$-1
	MOV	R10,R11
	AI	R11,18
	ASMIF	STKCHK=1
	C	@__stktop,R11
	JH	cvtexp010
	BL	@__stkoverflow
	TEXT	'__cvtexp'
	BYTE	0
	EVEN
	ASMEND
cvtexp010
	MOV	@2(R13),R9	Get arg pointer.
	MOV	*R9+,R7		Get number to convert.
	BLWP	@F$RITP
 	LD	*R7
	STD	@2(R10)
	XIT
	MOV	*R9+,R5		Get string pointer.
	MOV	*R9,R8		Get significant digits for number.
	CLR	R7		Exponent counter
	MOVB	@BLANK,R12	Set up for positive number.
	MOV	R0,R6		If zero
	JNE	cvtexp020
	MOVB	R12,*R5+	 then put out sign char
	JMP	cvtexp036	 and go process as scaled.
cvtexp020
	ANDI	R6,>8000	Check for negative number.
	JEQ	cvtexp030
	MOVB	@AMINUS,R12	  Yup, set '-' in buffer.
cvtexp030
	MOVB	R12,*R5+
	ANDI	R0,>7FFF	Make number positive.
	MOV	R0,R4
cvtexp032
	BLWP	@F$RITP
 	STD	@2(R10)		Save number.
 	CDE			Convert to integer.
	XIT
	MOV	R0,R0		if High order is set
	JNE	cvtexp034	  go process big number.
	MOV	R1,R6		if low order, may be big
	JNE	cvtexp036	  so go check
	BLWP	@F$RITP
 	LD	@2(R10)		It's a small number.
 	MD	@FTEN		Scale it up.
	XIT
	INC	R7		And bump exponent.
	JMP	cvtexp032
cvtexp034
	BLWP	@F$RITP
 	LD	@2(R10)		It's a big number.
 	DD	@FTEN		Scale it down.
 	STD	@2(R10)
 	CDE
	XIT
	INC	R7		Bump exponent.
	MOV	R0,R0		High order still set
	JNE	cvtexp034	  continue
cvtexp036
	C	R1,@TEN		If residual >= 10
	JHE	cvtexp034	  continue
	MOV	R1,R6		It's scaled down now.
cvtexp038
	SLA	R6,8		Convert digit to ASCII.
	AB	@AZERO,R6
	MOVB	R6,*R5+		Save it in buffer.
	MOVB	@DPT,*R5+	Add '.' in buffer.
	BLWP	@F$RITP
	CED			Float the residual.
 	STD	@10(R10)	Save last digit.
TEN	EQU	$-2
	XIT
cvtexp040
	BLWP	@F$RITP
 	LD	@2(R10)		Get scaled number.
 	SD	@10(R10)	Subtract last digit.
 	MD	@FTEN		Isolate
 	STD	@2(R10)		save
 	CDE			Convert to integer, digit
	XIT
	MOV	R1,R6
	SLA	R6,8		Make it ASCII
	AB	@AZERO,R6
	MOVB	R6,*R5+		Put in buffer.
	BLWP	@F$RITP
 	CED			Float it.
 	STD	@10(R10)	Save as last digit.
	XIT
	DEC	R8		Done with field?
	JGT	cvtexp040
	MOVB	@AE,*R5+	Yes, put 'E' in buffer.
	ANDI	R4,>FF00
	JEQ	cvtexp045
	CB	R4,@GTEXP	If initial exponent e+xx
	JLT	cvtexp050
cvtexp045
	MOVB	@APLUS,*R5+	  then put '+' in buffer.
	JMP	cvtexp060
cvtexp050
	MOVB	@AMINUS,*R5+	  else put '-' in buffer.
cvtexp060
	MOV	R7,R3		Get exponent count, from scale.
	CLR	R2
	DIV	@TEN,R2		Divide into two parts, -75..+75
	SLA	R2,8
	SLA	R3,8
	AB	@AZERO,R2
	AB	@AZERO,R3
	MOVB	R2,*R5+		And put exponent in buffer.
	MOVB	R3,*R5+
cvtexpxit
	SB	*R5,*R5
	MOV	R5,*R13
	RTWP
*
* Convert float number.
*
* char *_cvtfloat (double *num, char *stg, int len, int digits)
*
__cvtfloat
* function prologue 
	STWP	R10
	AI	R10,32
	MOV	R10,R11
APLUS	EQU	$+1		>2B (Don't change reg...)
	AI	R11,18
	ASMIF	STKCHK=1
	C	@__stktop,R11
	JH	cvtflt010
	BL	@__stkoverflow
	TEXT	'__cvtfloat'
	BYTE	0
	EVEN
	ASMEND
cvtflt010
	MOV	@2(R13),R9	Get arg pointer.
	MOV	*R9+,R7		Point to number to convert.
	BLWP	@F$RITP
	LD	@FP5		Set initial rounding value.
	STD	@10(R10)
 	LD	*R7		Get the number to convert.
	STD	@2(R10)
	XIT
	MOV	*R9+,R5		Get string pointer.
	MOV	*R9+,R8		Get total length of number.
	S	*R9,R8
	MOV	*R9,R7		Get number of digits.
	JEQ     cvtflt015
	DEC 	R8		Account for '.'
cvtflt015
	MOV	R0,R6		Is value non-zero and a
	JEQ	cvtflt025
	ANDI	R6,>8000	   positive number?
	JNE	cvtflt025
	MOV	R7,R4		Yes, do the rounding.
cvtflt020
	BLWP	@F$RITP		Set rounding value.
	LD	@10(R10)
	DD	@FTEN
	STD	@10(R10)
	XIT
	DEC	R4
	JGT	cvtflt020
	BLWP	@F$RITP		Round up value.
	LD	@2(R10)
	AD	@10(R10)
	STD	@2(R10)
	XIT
cvtflt025
	DEC 	R8		Account for 1 leading digit.
	CLR	R7		Leading digit counter
	CLR	R12
	MOV	R0,R6		If zero
	JEQ	cvtflt036	 go start printing.
	ANDI	R6,>8000	Check for negative number.
	JEQ	cvtflt030
	MOVB	@AMINUS,R12	  Yup, set '-' in buffer.
	DEC	R8
cvtflt030
	ANDI	R0,>7FFF	Make number positive.
	MOV	R0,R4
	BLWP	@F$RITP
 	STD	@2(R10)		Save number.
 	CDE			Convert to integer.
	XIT
	MOV	R0,R0		if High order is set
	JNE	cvtflt034	  go process big number.
	MOV	R1,R6		if low order, may be big
	JMP	cvtflt036	  so go check
cvtflt034
	BLWP	@F$RITP
 	LD	@2(R10)		It's a big number.
 	DD	@FTEN		Scale it down.
 	STD	@2(R10)
 	CDE
	XIT
	INC	R7		Bump leading digit count.
	MOV	R0,R0		High order still set
	JNE	cvtflt034	  continue
cvtflt036
	C	R1,@TEN		If residual >= 10
	JHE	cvtflt034	  continue
	S	R7,R8
	JLT	cvtflt038
	JEQ	cvtflt038
cvtflt037
	MOVB	@BLANK,*R5+
	DEC	R8
	JGT	cvtflt037
cvtflt038
	MOV	R12,R12		Do we have a sign?
	JEQ	cvtflt039
	MOVB	R12,*R5+	  yes, put in buffer.
cvtflt039
	MOV	*R9,R8		Get precision digits.
	MOV	R1,R6		It's scaled down now.
	SLA	R6,8		Convert digit to ASCII.
	AB	@AZERO,R6
	MOVB	R6,*R5+		Save it in buffer.
	BLWP	@F$RITP
 	CED			Float the residual.
 	STD	@10(R10)	Save last digit.
	XIT
	MOV	R7,R7		If we have no leading digit count
	JNE	cvtflt040
	MOV	R8,R8		 and precision
	JEQ	cvtfltxit
	MOVB	@DPT,*R5+	  put '.' into buffer.
	DEC	R7
cvtflt040
	BLWP	@F$RITP
 	LD	@2(R10)		Get scaled number.
 	SD	@10(R10)	Subtract last digit.
 	MD	@FTEN		Isolate
 	STD	@2(R10)		save
 	CDE			Convert to integer, digit
	XIT
	MOV	R1,R6
cvtflt043
	SLA	R6,8		Make it ASCII
	AB	@AZERO,R6
	MOVB	R6,*R5+		Put in buffer.
	BLWP	@F$RITP
 	CED			Float it.
 	STD	@10(R10)	Save as last digit.
	XIT
	MOV	R7,R7		If leading digits exahausted
	JLT	cvtflt050	 Go check trailing digits
	DEC	R7		Decrement leading digit count
	JNE     cvtflt040	If zero
	MOV	R8,R8		 and we have a precision.
	JEQ	cvtfltxit
	MOVB	@DPT,*R5+	  put '.' in buffer.
cvtflt050
	MOV	R8,R8
	JEQ	cvtfltxit
	DEC	R8		Done with trailing digits?
	JGT	cvtflt040
cvtfltxit
	SB	*R5,*R5
	MOV	R5,*R13
	RTWP
*
GTEXP	EQU	$		>41
FTEN	DOUBLE	10.0
FP5	DOUBLE	0.5
AZERO	BYTE	'0'
AMINUS	BYTE	'-'
DPT	BYTE	'.'
AE	BYTE	'E'
	END
