/************************************************************************
* fclose - Close a file.
************************************************************************/

#include <stdio.h>
#include <unistd.h>
#include <stdarg.h>
#include <stdlib.h>
#include <errno.h>
#include <sys/types.h>

int
fclose (FILE *ffd)
{
   FILE *pfd, *lfd;
   int status;

   if (ffd == NULL)
   {
      _errno = EBADF;
      return (-1);
   }

   if ((ffd->file_flags & _FILE_WRITE) && ffd->file_pos > 0)
      status = _writebuffer(ffd);

   if (ffd->file_num <= STDERR_FILENO)
      return (0);

   status = close (ffd->file_num);
#ifndef MINLIB
   _deltemp (ffd);
#endif

   lfd = _file_list;
   pfd = NULL;
   while (lfd)
   {
      if (lfd == ffd)
      {
	 if (pfd == NULL)
	    _file_list = lfd->file_next;
	 else
	    pfd->file_next = lfd->file_next;
         break;
      }
      pfd = lfd;
      lfd = lfd->file_next;
   }
   free (ffd->file_buf);
   free (ffd);

   return (status);
}
