/************************************************************************
* flushall - Flush and close all files. Also, clean up temporary files.
************************************************************************/

#include <stdio.h>
#include <unistd.h>
#include <errno.h>
#include <sys/types.h>

#ifndef MINLIB
static char
mkhex (int ch)
{
   ch &= 0xF;
   if (ch > 9)    
      return (ch + 0x37);
   return (ch + 0x30);
}

void 
_tempnam (char *name, int pid, int seq)
{
   *name++ = mkhex(pid >> 12);
   *name++ = mkhex(pid >> 8);
   *name++ = mkhex(pid >> 4);
   *name++ = mkhex(pid);
   *name++ = mkhex(seq >> 4);
   *name   = mkhex(seq);
}

void
_deltemp (FILE *fd)
{
   if (fd->file_flags & _FILE_TEMP)
   {
      int mypid = getpid();
      int seq = (fd->file_flags >> 8) & 0xFF;
      char path[10];

      strcpy (path, ".TMXXXXXX");
      _tempnam (&path[3], mypid, seq);
      unlink (path);
   }
}
#endif

void
_flushall (void)
{
   FILE *fd;

#ifdef DEBUGIO
   printf ("flushall: stdin = %p, stdout = %p, stderr = %p\n",
	    (void *)stdin, (void *)stdout, (void *)stderr);
#endif

   for (fd = _file_list; fd; fd = fd->file_next)
   {
#ifdef DEBUGIO
      printf (
	    "fd = %p, next = %p, lun = %d, flags = %04X, pos = %d, len = %d\n",
	       fd, fd->file_next, fd->file_num, fd->file_flags,
	       fd->file_pos, fd->file_len);
#endif
      if (fd->file_flags & _FILE_WRITE && fd->file_pos > 0)
      {
#ifdef DEBUGIO
	 if (!(fd->file_flags & _FILE_BINARY))
	    printf ("buf: %s\n", fd->file_buf);
#endif
	 _writebuffer (fd);
      }
#ifndef MINLIB
      close (fd->file_num);
      if (fd->file_num > STDERR_FILENO)
	 _deltemp (fd);
#endif
   }
}
