/************************************************************************
* fputc - Put a char in the file.
************************************************************************/

#include <stdio.h>
#include <unistd.h>
#include <errno.h>

int
fputc (int ch, FILE *fd)
{
   if (fd == NULL)
   {
      _errno = EBADF;
      return (-1);
   }

   fd->file_buf[fd->file_pos] = ch;
   fd->file_pos++;
   if (ch == '\n' || fd->file_pos >= BUFSIZ)
   {
      if (_writebuffer (fd) < 0)
	 return (EOF);
   }
   return (ch);
}
