/************************************************************************
* fputs - Print a line on the file.
************************************************************************/

#include <stdio.h>
#include <unistd.h>
#include <string.h>
#include <errno.h>

int
fputs (const char *stg, FILE *fd)
{
   char *up = (char *)stg;
   char *bp;

   if (fd == NULL)
   {
      _errno = EBADF;
      return (-1);
   }
   bp = &fd->file_buf[fd->file_pos];

   while (*up)
   {
      char ch = *up;

      *bp++ = *up++;
      fd->file_pos++;
      if (ch == '\n' || fd->file_pos >= BUFSIZ)
      {
         if (_writebuffer (fd) < 0)
	    return (EOF);
	 bp = fd->file_buf;
      }
   }

   return (0);
}
