/************************************************************************
* fread - Get a line from a file.
************************************************************************/

#include <stdio.h>
#include <unistd.h>
#include <string.h>
#include <errno.h>

size_t
fread (void *stg, size_t size, size_t num, FILE *fd)
{
   char *up = stg;
   char *bp;
   int cnt, len;

   if (fd == NULL)
   {
      _errno = EBADF;
      return (0);
   }
   
   if (fd->file_len == 0)
      _readbuffer (fd);
   if (fd->file_flags & (_FILE_ERROR | _FILE_EOF))
      return (0);

   bp = &fd->file_buf[fd->file_pos];
   len = 0;
   while (len < num)
   {
      cnt = size;
      while (cnt > 0)
      {
	 *up++ = *bp++;
	 fd->file_len--;
	 fd->file_pos++;
	 if (fd->file_len == 0)
	 {
	    _readbuffer (fd);
	    if (fd->file_flags & (_FILE_ERROR | _FILE_EOF))
	       return (len);
	    bp = fd->file_buf;
	 }
         cnt--;
      }
      len++;
   }

   return (len);
}
