/************************************************************************
* ftell - Tell a location in file. 
*         Only supported on relative record (random) files. 
************************************************************************/

#include <stdio.h>
#include <unistd.h>
#include <stddef.h>
#include <errno.h>
#include <sys/types.h>
#include <sys/svc.h>

off_t
ftell (FILE *fp)
{
   FileTable *ft;
   int i;

   /*
   ** Ensure that FILE ptr is good.
   */

   if (fp == NULL)
   {
      _errno = EBADF;
      return (-1);
   }

   ft = &_file_table[fp->file_num];

#ifdef DEBUGIO
   printf ("ftell: file_num = %d, attrflags = %X, lrl = %d, recnum = %d\n",
          fp->file_num, ft->attrflags, ft->logicalrecordlength, ft->recnum);
#endif

   if ((ft->attrflags & ATTRTYPEMASK) != ATTRRELRECORD)
   {
      _errno = EPERM;
      return (-1);
   }

   if (ft->recnum == 0)
      i = fp->file_pos;
   else
      i = ((ft->recnum - 1) * ft->logicalrecordlength) + fp->file_pos;

   return (i);
}
