/************************************************************************
* getpid - Get process id.
************************************************************************/

#include <unistd.h>
#include <sys/types.h>
#include <sys/svc.h>

pid_t
getpid (void)
{
   SVCGetPid svc;

   svc.opcode = SVCGETPID;
   svc.runid = 0;
   svc.insid = 0;
   svc.staid = 0;
   svc.res1 = 0;
   svc.res2 = 0;

   _issue_svc ((SVCBlk *)&svc);

   return ((svc.runid << 8) | svc.staid);
}
