#ifndef __DIRENT_H__
#define __DIRENT_H__

#ifndef __TYPES_H__
#include <sys/types.h>
#endif

#include <sys/dir.h>

#define _DIRENT_NAME_LEN 12

struct dirent {
   ino_t        d_ino;		/* I-node number */
   unsigned int	d_flags;	/* flags */
   long 	d_size;		/* Size */
   char         d_name[_DIRENT_NAME_LEN];	/* Null terminated name */
};

/* Definitions for the directory(3) routines: */

typedef struct {
   char          dd_fd;		/* File descriptor of open directory */
   short         dd_count;	/* This many records in directory */
   off_t         dd_pos;	/* Position in directory file */
   off_t         dd_sec;	/* Current sector in directory file */
   struct direct dd_buf; 	/* One record of a directory file */
   struct dirent dd_dir;	/* Converted dirent info */
} DIR;

/* Function Prototypes. */

int closedir(DIR *);
DIR *opendir(const char *);
struct dirent *readdir(DIR *);
void rewinddir(DIR *);
void seekdir(DIR *, off_t);
off_t telldir(DIR *);

#endif
