#ifndef __ERRNO_H__
#define __ERRNO_H__

#define	EPERM		 1	/* Operation not permitted */
#define	ENOENT		 2	/* No such file or directory */
#define	ESRCH		 3	/* No such process */
#define	EINTR		 4	/* Interrupted system call */
#define	EIO		 5	/* I/O error */
#define	ENXIO		 6	/* No such device or address */
#define	E2BIG		 7	/* Arg list too long */
#define	ENOEXEC		 8	/* Exec format error */
#define	EBADF		 9	/* Bad file number */
#define	ECHILD		10	/* No child processes */
#define	EAGAIN		11	/* Try again */
#define	ENOMEM		12	/* Out of memory */
#define	EACCES		13	/* Permission denied */
#define	EFAULT		14	/* Bad address */
#define	ENOTBLK		15	/* Block device required */
#define	EBUSY		16	/* Device or resource busy */
#define	EEXIST		17	/* File exists */
#define	EXDEV		18	/* Cross-device link */
#define	ENODEV		19	/* No such device */
#define	ENOTDIR		20	/* Not a directory */
#define	EISDIR		21	/* Is a directory */
#define	EINVAL		22	/* Invalid argument */
#define	ENFILE		23	/* File table overflow */
#define	EMFILE		24	/* Too many open files */
#define	ENOTTY		25	/* Not a typewriter */
#define	ETXTBSY		26	/* Text file busy */
#define	EFBIG		27	/* File too large */
#define	ENOSPC		28	/* No space left on device */
#define	ESPIPE		29	/* Illegal seek */
#define	EROFS		30	/* Read-only file system */
#define	EMLINK		31	/* Too many links */
#define	EPIPE		32	/* Broken pipe */
#define	EDOM		33	/* Math argument out of domain of func */
#define	ERANGE		34	/* Math result not representable */
#define	EDEADLK		35	/* Resource deadlock would occur */
#define	ENAMETOOLONG	36	/* File name too long */
#define	ENOLCK		37	/* No record locks available */
#define	ENOSYS		38	/* Function not implemented */

/* network */
#define ENETSTAT	39	/* user status available (not an error) */
#define ENETDOWN	40	/* net not available */
#define ENETCON		41	/* too many net connections */
#define ENETBUF		42	/* no more net buffer space */
#define ENETPARM	43	/* bad mode in net open or request in ioctl */
#define ENETRNG		44	/* bad addr, port, raw link or proto range */
#define ENETDED		45	/* can't open: destination dead */
#define ERAWBAD		46	/* unable to send on raw connection */
#define ENETERR		47	/* attempt I/O on closed connection */
#define ENETREF		48	/* destination refused (reset) */
#define ENETUNR		49	/* destination unreachable */
#define ENETTIM		50	/* destination not responding (timeout) */

#define __MAX_ERRNO	51
#define errno _errno
extern int errno;

void _maperr(int);

#endif
