#ifndef _SGTTY_H_
#define _SGTTY_H_ 1

struct sgttyb {
	char	sg_ispeed;		/* input speed */
	char	sg_ospeed;		/* output speed */
	char	sg_erase;		/* erase character */
	char	sg_kill;		/* kill character */
	int	sg_flags;		/* mode flags */
};

/*
 * sg_flags bits.
 */
#define	TANDEM	 0000001
#define	CBREAK	 0000002
#define	LCASE	 0000004
#define	ECHO	 0000010
#define	CRMOD	 0000020
#define	RAW	 0000040
#define	ODDP	 0000100
#define	EVENP	 0000200
#define ANYP	 0000300
#define	NLDELAY	 0001400
#define	TBDELAY	 0001000
#define	XTABS	 0002000
#define DAVAIL	 0010000
#define	CRDELAY	 0020000
#define	VTDELAY	 0040000
#define BSDELAY  0100000
#define ALLDELAY 0177400

/*
 * Delay algorithms
 */
#define	CR0	0
#define	CR1	010000
#define	CR2	020000
#define	CR3	030000
#define	NL0	0
#define	NL1	000400
#define	NL2	001000
#define	NL3	001400
#define	TAB0	0
#define	TAB1	002000
#define	TAB2	004000
#define	FF0	0
#define	FF1	040000
#define	BS0	0
#define	BS1	0100000

/*
 * Speeds
 */
#define B0	0
#define B50	1
#define B75	2
#define B110	3
#define B134	4
#define B150	5
#define B200	6
#define B300	7
#define B600	8
#define B1200	9
#define	B1800	10
#define B2400	11
#define B4800	12
#define B9600	13
#define B19200	14
#define EXTA	B19200
#define EXTB	15

extern int stty (int, struct sgttyb *);
extern int gtty (int, struct sgttyb *);

#endif /* _SGTTY_H_ */
