#ifndef __SVC_H__
#define __SVC_H__

#include <stddef.h>

/* SVC codes */

#define SVCIO		0x00
#define SVCWIOC		0x01
#define SVCSLEEP	0x02
#define SVCDATE		0x03
#define SVCENDTSK	0x04
#define SVCBIDTSK 	0x05
#define SVCGETCMN	0x10
#define SVCGETMEM	0x12
#define SVCPUTMEM	0x13
#define SVCENDPGM	0x16
#define SVCPUTCMN	0x1B
#define SVCSYSLOG	0x21
#define SVCSETPRV	0x23
#define SVCGETPID	0x2E

/* I/O subopcode */

#define OPEN		0x00
#define CLOSE		0x01
#define CLOSEEOF	0x02
#define OPENREWIND	0x03
#define CLOSEUNLOAD	0x04
#define READCHAR	0x05
#define FSRECORD	0x06
#define BSRECORD	0x07
#define READASCII	0x09
#define READBINARY	0x0A
#define WRITEASCII	0x0B
#define WRITEBINARY	0x0C
#define WRITEEOF	0x0D
#define REWIND		0x0E
#define UNLOAD		0x0F

#define FORMATTRACK	0x08
#define DEVICECHAR	0x0F

#define CREATEFILE	0x90
#define ASSIGNFILE	0x91
#define DELETEFILE	0x92
#define RELEASEFILE	0x93
#define RENAMEFILE	0x95

/* System flags */

#define SYSBUSY		0x80
#define SYSERROR	0x40
#define SYSEOF		0x20

/* User flags */

#define USERINITIATE	0x80
#define USERREPLY	0x40
#define USEREXCLWRITE	0x00
#define USEREXCLALL	0x08
#define USERSHARED	0x10
#define USERREADONLY	0x18
#define USERNOREPLACE	0x04
#define USERCOMMTO	0x02
#define USERTERMBLK	0x02
#define USERBLKADJ	0x01

/* Utility flags */

#define UTILASSIGN	0x8000
#define UTILPLAIN	0x0000
#define UTILDIRECTORY	0x2000
#define UTILPROGRAM	0x4000
#define UTILIMAGE	0x6000
#define UTILTASKLOCAL   0x0000
#define UTILSTATLOCAL   0x0800
#define UTILGLOBAL	0x1000
#define UTILGENLUNO	0x0400
#define UTILAUTOCREATE	0x0200
#define UTILLRLFLAG	0x0080
#define UTILTEMPFILE	0x0040
#define UTILIMMWRITE	0x0020
#define UTILNORMAL	0x0000
#define UTILBLKSUPPRESS	0x0008
#define UTILEXPANDABLE	0x0004
#define UTILDEVICE	0x0000
#define UTILSEQUENTIAL	0x0001
#define UTILRANDOM	0x0002
#define UTILKEYINDEX	0x0003

/* Attribute flags */

#define ATTRUSAGEMASK	0xC000
#define ATTRIMAGE	0xC000
#define ATTRPROGRAM	0x8000
#define ATTRDIRECTORY	0x4000
#define ATTRBLANKSSUP	0x1000
#define ATTREXPANDABLE	0x0800
#define ATTRTYPEMASK    0x0600
#define ATTRKEYINDEXED	0x0600
#define ATTRRELRECORD	0x0400
#define ATTRSEQUENTIAL	0x0200
#define ATTRWRITEPROT	0x0100
#define ATTRDELETEPROT	0x0080
#define ATTRTEMPFILE	0x0040
#define ATTRUNBLOCKED	0x0020
#define ATTRIMMWRITE	0x0008
#define ATTRCRLFDEVICE	0x0007

/* Terminal extended flags */

#define TERMFIELDSTART	0x8000
#define TERMBOLD	0x4000
#define TERMBLINK	0x2000
#define TERMGRAPHICS	0x1000
#define TERM8BITCRLF	0x0800
#define TERMTASKEDIT	0x0400
#define TERMBEEP	0x0200
#define TERMRIGHTBOUND	0x0100
#define TERMCURPOS	0x0080
#define TERMUSEFILL	0x0040
#define TERMFIELDNOINIT	0x0020
#define TERMTERMCHAR	0x0010
#define TERMNOECHO	0x0008
#define TERMCHARVALID	0x0004
#define TERMFIELDERR	0x0002
#define TERMWBEEP	0x0001

typedef struct {
   byte_t opcode;
   byte_t status;
} SVCBlk;

typedef struct {
   byte_t opcode;
   byte_t status;
   word_t res1;
   char *message;
   word_t res2;
} SVCLOGBlk;

typedef struct {
   byte_t opcode;
   byte_t status;
   byte_t subopcode;
   byte_t luno;
   byte_t sysflags;
   byte_t userflags;
   void *buffer;
   word_t logicalrecordlength;
   word_t charactercount;
   void *keyindexdefinition;
   word_t recnum;
   word_t utilityflags;
   word_t definedlogicalrecordlength;
   word_t definedphysicalrecordlength;
   char *pathname;
   word_t reserved2;
   word_t reserved3;
   word_t initialallocation[2];
   word_t secondaryallocation[2];
} SVCIOBlk;

typedef struct {
   byte_t opcode;
   byte_t status;
   byte_t subopcode;
   byte_t luno;
   byte_t sysflags;
   byte_t userflags;
   void *buffer;
   word_t logicalrecordlength;
   word_t charactercount;
   word_t trackaddress;
   byte_t sectorrecord;
   byte_t sectoraddress;
} SVCIODDisk;

typedef struct {
   byte_t opcode;
   byte_t status;
   unsigned int time;
} SVCSleep;

typedef struct {
   byte_t opcode;
   byte_t status;
   char *datblk;
   int year;
   int day;
   int hour;
   int minute;
   int second;
} SVCDate;

typedef struct {
   byte_t opcode;
   byte_t status;
   byte_t event;
   byte_t luno;
} SVCEvtBlk;

typedef struct {
   byte_t opcode;
   byte_t runid;
   byte_t insid;
   byte_t staid;
   byte_t res1;
   byte_t res2;
} SVCGetPid;

extern int _issue_svc (SVCBlk *);
extern byte_t _curluno;

#endif
