#ifndef __UNISTD_H__
#define __UNISTD_H__

#include <stdio.h>
#include <sys/types.h>

#ifndef MAXPATHNAMESIZE
#define MAXPATHNAMESIZE 255
#endif
#define MAXRECORDSIZE 256
#define __MAXLUNO 10
#define __MINLUNO 3

#define STDIN_FILENO 0
#define STDOUT_FILENO 1
#define STDERR_FILENO 2

/* Values for the second argument to access.
   These may be OR'd together.  */
#define R_OK    4               /* Test for read permission.  */
#define W_OK    2               /* Test for write permission.  */
#define X_OK    1               /* Test for execute permission.  */
#define F_OK    0               /* Test for existence.  */

/* Values for the WHENCE argument to lseek.  */
#ifndef __STDIO_H__             /* <stdio.h> has the same definitions.  */
# define SEEK_SET       0       /* Seek from beginning of file.  */
# define SEEK_CUR       1       /* Seek from current position.  */
# define SEEK_END       2       /* Seek from end of file.  */
#endif

extern int open (const char *, int oflag, ...);
extern int creat (const char *, int omode);
extern int close (int);

extern int write (int, const void *, int);
extern int read (int, void *, int);

extern int isatty (int);
extern int access (const char *, int);

extern off_t lseek (int, off_t, int);

extern int unlink (const char *);

extern unsigned int sleep (unsigned int);
extern pid_t getpid (void);

/* Some internal routines */

extern int _writeline (int, const void *, int);
extern int _readline (int, void *, int);
extern int _printline (int, const void *, int);

extern int _setpath (char *, char *);
extern void _flushall (void);

extern int _readbuffer (FILE *);
extern int _writebuffer (FILE *);

#define FTINUSE 0100000
#define FTISNET 0040000

typedef struct {
   int	modes;
   int  type;
   unsigned int attrflags;
   int  physicalrecordlength;
   int	logicalrecordlength;
   long numberofrecords;
   int  pfileonly;
   int  recnum;
} FileTable ;

extern FileTable _file_table[__MAXLUNO];

#endif
