/************************************************************************
* malloc - Allocate a block of storage from the heap.
************************************************************************/

#include <stdlib.h>

extern Malloc_blk *_heapbottom;
extern char *_heaptop;

#ifndef NULL
#define NULL ((void *)0)
#endif

void *
malloc (size_t size)
{
   Malloc_blk *cm, *nm;
   char *umem;
   size_t blksize;
   int found;

   if (size == 0)
      return (NULL);

   /*
   ** Size if user request + overhead
   */

   blksize = ((size + 1) & 0xFFFE) + sizeof (Malloc_blk);

   /*
   ** Locate an empty slot
   */

   cm = _heapbottom;
   found = 0;
   umem = NULL;
   while (cm)
   {
      if (cm->size >= blksize && cm->flags == 0)
      {
         found = 1;
	 break;
      }
      cm = cm->next;
   }

   /*
   ** Found a slot
   */

   if (found && (((char *)cm + blksize) < _heaptop))
   {
      /*
      ** If at end, carve out a chunk
      */

      if (!cm->next)
      {
	 size_t blen;

	 umem = (char *)cm + blksize;
	 nm = (Malloc_blk *)umem;
	 blen = cm->size - blksize;
	 if (blen > sizeof (Malloc_blk))
	 {
	    nm->size = blen;
	    nm->flags = 0;
	    nm->back = cm;
	    nm->next = NULL;
	    cm->next = nm;
	    cm->size = blksize;
	 }
      }

      /*
      ** In middle, carve out a chunk if smaller than block.
      */

      else if (cm->size > (blksize + (sizeof (Malloc_blk)*2)))
      {
	 umem = (char *)cm + blksize;
	 nm = (Malloc_blk *)umem;
	 nm->size = cm->size - blksize;
	 nm->flags = 0;
	 nm->back = cm;
	 nm->next = cm->next;
	 cm->next->back = nm;
	 cm->next = nm;
	 cm->size = blksize;
      }

      cm->flags = 1;
      umem = (char *)cm + sizeof (Malloc_blk);
   }

   return ((void *)umem);
}
