#include <float.h>

#define EXP_MAX 252
extern double _powtab[EXP_MAX + 1];
extern int _initpowtab (void);

#define INIT() (_powtab[0]?0:_initpowtab())
#define pow2(i) _powtab[i]

double
frexp (double f, int *p)
{
   int k;
   int x;
   double g;

#ifdef DEBUG_FREXP
   printf ("frexp: f = %e\n", f);
#endif
   INIT ();

   /*
    * normalize
    */

   x = k = EXP_MAX / 2;
   if (f < 1.0)
   {
      g = 1.0 / f;
      for (;;)
      {
         k = (k + 1) / 2;
#ifdef DEBUG_FREXP
         printf ("pow2(%d) = %e, k = %d\n", x, pow2 (x), k);
#endif
         if (g < pow2 (x))
            x -= k;
         else if (k == 1 && g < pow2 (x + 1))
            break;
         else
            x += k;
      }
      if (g == pow2 (x))
         x--;
      x = -x;
   }
   else if (f > 1)
   {
      for (;;)
      {
         k = (k + 1) / 2;
#ifdef DEBUG_FREXP
         printf ("pow2(%d) = %e, k = %d\n", x, pow2 (x), k);
#endif
         if (f > pow2 (x))
            x += k;
         else if (k == 1 && f > pow2 (x - 1))
            break;
         else
            x -= k;
      }
      if (f == pow2 (x))
         x++;
   }
   else
      x = 1;
   *p = x;

   /*
    * shift
    */

   x = -x;
   if (x < 0)
      f /= pow2 (-x);
   else if (x < EXP_MAX)
      f *= pow2 (x);
   else
      f = (f * pow2 (EXP_MAX - 1)) * pow2 (x - (EXP_MAX - 1));
   return f;
}
