#include <float.h>

#define EXP_MAX 252
extern double _powtab[EXP_MAX + 1];
extern int _initpowtab (void);

#define INIT() (_powtab[0]?0:_initpowtab())
#define pow2(i) _powtab[i]

double
ldexp (double f, int x)
{
   INIT ();
   if (x < 0)
      f /= pow2 (-x);
   else if (x < EXP_MAX)
      f *= pow2 (x);
   else
      f = (f * pow2 (EXP_MAX - 1)) * pow2 (x - (EXP_MAX - 1));
   return f;
}
