/************************************************************************
* open - Open a file.
************************************************************************/

#include <stdio.h>
#include <unistd.h>
#include <stdarg.h>
#include <errno.h>
#include <memory.h>
#include <string.h>
#include <fcntl.h>
#include <sys/svc.h>

extern int _istxds;

int
open (const char *path, int oflag, ...)
{
   FileTable *ft;
   int m;
   int fd;
   int isdev;
   SVCIOBlk svc;
   char filepath[MAXPATHNAMESIZE+2];


#ifdef DEBUGIO
   printf ("open: path = %s, oflag = %X\n", path, oflag);
#endif

   memset (&svc, 0, sizeof(SVCIOBlk));

   /*
   ** Check if we have a device.
   */
   isdev = FALSE;
   if (strlen (path) == 4 && strchr (path, '.') == NULL)
      isdev = TRUE;

   /*
   ** Test oflag for proper modes and only one.
   */
   m = 0;
   if (oflag & O_RDONLY) m++;
   if (oflag & O_WRONLY) m++;
   if (oflag & O_RDWR) m++;
   if (m != 1)
   {
      _errno = EINVAL;
      return (-1);
   }

   /*
   ** Copy pathname and upcase
   */

   _setpath (filepath, (char *)path);

   /*
   ** Assign luno to the file
   */

   _errno = 0;
   for (fd = __MINLUNO; fd < __MAXLUNO; fd++)
   {
      ft = &_file_table[fd];
      if (!(ft->modes & FTINUSE)) break;
   }
   if (fd == __MAXLUNO)
   {
      _errno = EMFILE;
      return (-1);
   }

   svc.opcode = SVCIO;
   svc.luno = fd;
   svc.subopcode = ASSIGNFILE;
   svc.pathname = filepath;
   if (isdev)
   {
      svc.utilityflags = UTILDEVICE;
      svc.definedlogicalrecordlength = 0;
   }
   else
   {
      svc.utilityflags = UTILSEQUENTIAL | UTILLRLFLAG |
			 UTILBLKSUPPRESS | UTILEXPANDABLE;
      if (oflag & O_CREAT)
	 svc.utilityflags |= UTILAUTOCREATE;
      svc.definedlogicalrecordlength = BUFSIZ;
   }

   _issue_svc ((SVCBlk *)&svc);
   if (svc.status)
   {
      _maperr(svc.status);
#ifdef DEBUGIO
      printf ("   assign: status = %d, errno = %d\n", svc.status, _errno);
#endif
      return (-1);
   }
   
   /*
   ** Open the file
   */

   svc.subopcode = OPENREWIND;

   _issue_svc ((SVCBlk *)&svc);
   if (svc.status)
   {
      _maperr(svc.status);
#ifdef DEBUGIO
      printf ("   openreq: status = %d, errno = %d\n", svc.status, _errno);
#endif
      goto RELEASE;
   }
   ft->type = (int)svc.buffer;
#ifdef DEBUGIO
   printf ("   type = %d, lrl = %d\n", ft->type, svc.logicalrecordlength);
#endif

   /*
   ** Read the file characteristics
   */

   if (!isdev)
   {
      svc.subopcode = READCHAR;
      svc.buffer = &ft->attrflags;
      svc.logicalrecordlength = 12;
      svc.charactercount = 12;

      _issue_svc ((SVCBlk *)&svc);
      if (svc.status)
      {
	 _errno = EIO;
#ifdef DEBUGIO
      printf ("   readchar: status = %d, errno = %d\n", svc.status, _errno);
#endif
	 goto CLOSE_ALL;
      }

      if (_istxds && (ft->logicalrecordlength == 0))
	 ft->attrflags |= ATTRCRLFDEVICE;
      if (ft->attrflags & ATTRCRLFDEVICE)
      {
	 ft->physicalrecordlength = 0;
	 ft->logicalrecordlength = 0;
	 ft->numberofrecords = 0;
      }
#ifdef DEBUGIO
      printf ("   filechar: flags = %X, prl = %d, lrl = %d, nrecs = %ld\n",
	      ft->attrflags, ft->physicalrecordlength, ft->logicalrecordlength,
	      ft->numberofrecords);
#endif
   }
   else
   {
      ft->physicalrecordlength = 0;
      ft->logicalrecordlength = 0;
      ft->numberofrecords = 0;
   }

   ft->modes = FTINUSE | oflag;
   ft->recnum = 0;

   return (fd);

CLOSE_ALL:
   svc.subopcode = CLOSE;
   _issue_svc ((SVCBlk *)&svc);
RELEASE:
   svc.subopcode = RELEASEFILE;
   _issue_svc ((SVCBlk *)&svc);
   return (-1);
}
