/************************************************************************
* printf - Print a formatted line on stdout.
************************************************************************/

#include <stdio.h>
#include <string.h>
#include <stdarg.h>

int
printf (const char *fmt, ...)
{
   int i;
   va_list ap;
   char obuf[BUFSIZ];

   va_start (ap, fmt);
   i = vsprintf (obuf, fmt, ap);
   va_end (ap);

   if (fputs (obuf, stdout) < 0)
      return (-1);

   return (i);
}
