/************************************************************************
* read - Read from an open file.
************************************************************************/

#include <unistd.h>
#include <errno.h>
#include <string.h>
#include <memory.h>
#include <fcntl.h>
#include <sys/svc.h>

extern word_t _termusrflag;

int
read (int fd, void *buffer, int count)
{
   FileTable *ft;
   SVCIOBlk svc;

   _errno = 0;

   if (fd >= __MAXLUNO)
   {
      _errno = EBADF;
      return (-1);
   }
   ft = &_file_table[fd];

   /*
   ** If stdin, stderr, stdout read line
   */

   if (fd <= STDERR_FILENO)
   {
      if (ft->modes & O_NONBLOCK)
         _termusrflag |= USERINITIATE;
      else
         _termusrflag &= ~USERINITIATE;
      return (_readline (fd, buffer, count));
   }

   memset (&svc, 0, sizeof (SVCIOBlk));

   if (!(ft->modes & FTINUSE))
   {
      _errno = EBADF;
      return (-1);
   }

#ifdef DEBUGIO
   printf ("read: buffer = %p, count = %d\n", buffer, count);
#endif

   /*
   ** Read from file
   */

   svc.opcode = SVCIO;
   svc.subopcode = READASCII;
   svc.luno = fd;
   svc.buffer = buffer;
   svc.logicalrecordlength = count;
   svc.charactercount = count;
   svc.recnum = ft->recnum;
   ft->recnum ++;

   /*
   ** Return EOF if we've exceeded the record count 
   */

   if (ft->numberofrecords && ft->recnum >= ft->numberofrecords)
   {
      return (0);
   }

   _issue_svc ((SVCBlk *)&svc);
   if (svc.sysflags & SYSEOF)
   {
#ifdef DEBUGIO
      printf ("   SYSEOF set\n");
#endif
      return (0);
   }
   if (svc.status)
   {
#ifdef DEBUGIO
      printf ("   status set: %d\n", svc.status);
#endif
      if (svc.status == 0x30)
	 return (0);

      _errno = EIO;
      return (-1);
   }

#ifdef DEBUGIO
   printf ("   read = %d\n", svc.charactercount);
#endif

   return (svc.charactercount);
}
