/************************************************************************
* readdir - Read a directory entry.
************************************************************************/

#include <unistd.h>
#include <errno.h>
#include <string.h>
#include <memory.h>
#include <sys/types.h>
#include <dirent.h>
#include <sys/svc.h>

#ifdef DEBUGDIRIO
#include "hexdump.h"
#endif

struct dirent *
readdir (DIR *dp)
{
   long lrecl, drecs;
   struct dirent *ep;
   int fd;
   int i;
   SVCIOBlk svc;

   _errno = 0;

   if (dp == NULL)
   {
      _errno = EBADF;
      return (NULL);
   }

   ep = NULL;
   memset (&svc, 0, sizeof (SVCIOBlk));
   fd = dp->dd_fd;

#ifdef DEBUGDIRIO
   printf ("readdir: dp = %p, fd = %d\n", dp, fd);
#endif

   /*
   ** Read from directory, empty entries have null in the name
   */

   do {
#ifdef DEBUGDIRIO
      printf ("   pos = %u\n", dp->dd_pos);
#endif
      svc.opcode = SVCIO;
      svc.subopcode = READBINARY;
      svc.luno = fd;
      svc.buffer = (char *) &dp->dd_buf.dir.dxdir;
      svc.logicalrecordlength = sizeof(dp->dd_buf.dir.dxdir);
      svc.charactercount = sizeof(dp->dd_buf.dir.dxdir);
      svc.recnum = dp->dd_pos;
      dp->dd_pos++;

      _issue_svc ((SVCBlk *)&svc);
      if (svc.sysflags & SYSEOF)
	 return (NULL);
      if (svc.status)
      {
	 if (svc.status == 0x30)
	    return (NULL);

	 _errno = EIO;
	 return (NULL);
      }
   } while (dp->dd_buf.dir.dxdir.d_name[0] == 0);


#ifdef DEBUGDIRIO
   printf ("   read = %d, rec = %d\n", svc.charactercount, svc.recnum);
   printf ("   flags = %04X, precl = %d, lrecl = %d, recs = %d\n",
      dp->dd_buf.dir.dxdir.d_flags, dp->dd_buf.dir.dxdir.d_precl,
      dp->dd_buf.dir.dxdir.d_lrecl, dp->dd_buf.dir.dxdir.d_recs);
   HEXDUMP (stdout, (char *)&dp->dd_buf, 134, 0);
#endif

   ep = (struct dirent *) &dp->dd_dir;
   ep->d_ino = 0;
   ep->d_flags = dp->dd_buf.dir.dxdir.d_flags;
   if (dp->dd_buf.dir.dxdir.d_recs > 0)
   {
      lrecl = (dp->dd_buf.dir.dxdir.d_lrecl + 1);
      drecs = dp->dd_buf.dir.dxdir.d_recs - 1;
      ep->d_size = lrecl * drecs;
   }
   else 
   {
      ep->d_size = 0;
   }

   memcpy (ep->d_name, dp->dd_buf.dir.dxdir.d_name, DIRSIZ);
   ep->d_name[DIRSIZ] = 0;
   for (i = DIRSIZ-1; i; i--)
      if (ep->d_name[i] == ' ') ep->d_name[i] = 0;
      else break;

   return (ep);
}
