/************************************************************************
* rename - Rename a file.
************************************************************************/

#include <stdio.h>
#include <unistd.h>
#include <stdarg.h>
#include <errno.h>
#include <memory.h>
#include <string.h>
#include <fcntl.h>
#include <sys/svc.h>

int
rename (const char *oldpath, const char *newpath)
{
   FileTable *ft;
   int fd;
   int status;
   SVCIOBlk svc;
   char filepath[MAXPATHNAMESIZE+2];


#ifdef DEBUGIO
   printf ("open: oldpath = %s, newpath = %s\n", oldpath, newpath);
#endif

   memset (&svc, 0, sizeof(SVCIOBlk));
   status = 0;

   /*
   ** Assign luno to the old file
   */

   _errno = 0;
   _setpath (filepath, (char *)oldpath);
   for (fd = __MINLUNO; fd < __MAXLUNO; fd++)
   {
      ft = &_file_table[fd];
      if (!(ft->modes & FTINUSE))
         break;
   }
   if (fd == __MAXLUNO)
   {
      _errno = EMFILE;
      return (-1);
   }

   svc.opcode = SVCIO;
   svc.luno = fd;
   svc.subopcode = ASSIGNFILE;
   svc.utilityflags = UTILSEQUENTIAL | UTILLRLFLAG |
		      UTILBLKSUPPRESS | UTILEXPANDABLE;
   svc.pathname = filepath;
   svc.definedlogicalrecordlength = BUFSIZ;

   _issue_svc ((SVCBlk *)&svc);
   if (svc.status)
   {
      _maperr(svc.status);
      return (-1);
   }
   
   /*
   ** Rename the file
   */

   _setpath (filepath, (char *)newpath);
   svc.subopcode = RENAMEFILE;
   svc.pathname = filepath;

   _issue_svc ((SVCBlk *)&svc);
   if (svc.status)
   {
      _maperr(svc.status);
      status = -1;
   }

   svc.subopcode = RELEASEFILE;
   _issue_svc ((SVCBlk *)&svc);

   return (status);
}
