/************************************************************************
* setpath - Set up a path name.
************************************************************************/

#include <stdio.h>
#include <unistd.h>
#include <stdarg.h>
#include <errno.h>

extern int _mapsyn (char *, char *);
extern int _istxds;

int
_setpath (char *filepath, char *path)
{
   byte_t i;
   char filetemp[MAXPATHNAMESIZE+2];

   /*
   ** Copy pathname and upcase
   */

   for (i = 0; path[i]; i++)
   {
      char ch;
      ch = path[i];
      if (ch >= 'a' && ch <= 'z') ch -= 0x20;
      else if (_istxds && ch == '.') ch = '/';
      filetemp[i+1] = ch;
   }
   filetemp[i+1] = '\0';
   filetemp[0] = i;

   /*
   ** Map Synonyms
   */

   _mapsyn (filepath, filetemp);

   return (0);
}
