*
* Module F$FITP 
* Floating point interpreter. Decodes operation and dispatches.
*
	IDT	'F$FITP'
	OPTION	BUNLST,DUNLST,TUNLST
*
	DEF	F$FITP
*
	SREF	F$XAD
	SREF	F$XAR
	SREF	F$XCDE
	SREF	F$XCDI
	SREF	F$XCED
	SREF	F$XCER
	SREF	F$XCID
	SREF	F$XCIR
	SREF	F$XCRE
	SREF	F$XCRI
	SREF	F$XDD
	SREF	F$XDR
	SREF	F$XLD
	SREF	F$XLR
	SREF	F$XMD
	SREF	F$XMR
	SREF	F$XNGD
	SREF	F$XNGR
	SREF	F$XSD
	SREF	F$XSR
	SREF	F$XSTD
	SREF	F$XSTR
*
F$FITP	EQU	$
	MOV	*R14+,R2	Pick up OpCode.
	MOV	R2,R0
	ANDI	R0,>FC00
	CI	R0,>0C00
	JEQ	CHKOPR
*
* Illegal code or instruction
*
ILLOP	EQU	$
	IDLE
	JMP	F$FITP
*
CHKOPR	EQU	$		Check operand
	LI	R7,4		Get SGL precision operand length.
	CI	R2,>0E00	Is this a DBL precision Op?
	JLT	SGLPRE
	LI	R7,8		yes, set DBL precision length.
SGLPRE	EQU	$
	MOV	R2,R1
	SRL	R2,5
	ANDI	R2,>001E	Is this a non-operand inst?
	JEQ	NOOPND		Yes, go process
	ANDI	R1,>003F
	CI	R1,>0020	It it non-indexed memory?
	JEQ	NOINDX		 Yes, go get it.
	MOV	R1,R0		No, isolate register.
	ANDI	R1,>000F
	SLA	R1,1
	A	R13,R1		Add callers WP.
	SRL	R0,4		Isolate tag.
	BL	@PRCOPR		Go process operand.
	MOV	R1,R9
	JMP	GODISP
NOINDX	EQU	$
	MOV	*R14+,R9
GODISP	EQU	$
	MOV	R13,R10
	STWP	R7
	AI	R7,>002C
	MOV	@OPERND(R2),R2
DISPAT	EQU	$
	BL	*R2		Go Process instruction.
	JMP	ERROR
	JMP	F$FITP
*
NOOPND	EQU	$		A no operand instruction.
	ANDI	R1,>000F
	SLA	R1,1
	MOV	R13,R9
	MOV	R13,R10
	MOV	@NOOPRD(R1),R2
	JMP	DISPAT
*
* Error encountered (we ignore it).
*
ERROR	EQU	$
	CI	R8,>4000	Underflow?
	JEQ	F$F018
	CI	R8,>2000	Divide by zero?
	JEQ	F$F018
* Overflow
F$F018	EQU	$
	JMP	F$FITP
*
XIT	EQU	$		Exit the interpreter.
	STWP	R10
	RTWP
*
* Process operand, returns operand address.
*
PRCOPR	EQU	$
	ANDI	R0,>0003	Register?
	JEQ	REGREF		Yes, go get value.
	CI	R0,>0003	Indirect-auto increment?
	JEQ	INDINC		Yes, 
	C	R1,R13		Indexed?
	JNE	INDREG		Yes, go get it.
	CI	R0,>0001	Indirect Register?
	JEQ	INDREG
INDINC	EQU	$
	MOV	*R1,R0		Get current register value.
	A	R7,R0		Increment.
	MOV	R1,R7
	MOV	*R1,R1
	MOV	R0,*R7
	RT
INDREG	EQU	$
	MOV	*R1,R1		Get callers register.
	DEC	R0		Just indirect?
	JEQ	GETXIT		Yes, exit
	A	*R14+,R1	Indexed, Add operand value.
GETXIT	EQU	$
	RT
REGREF	MOV	*R1,R1		Get callers register.
	RT
	PAGE
*
* Operand instruction dispatch table.
*
OPERND	EQU	$
	DATA	>2000
	DATA	F$XAR		>0C40
	DATA	F$XCIR		>0C80
	DATA	F$XSR		>0CC0
	DATA	F$XMR		>0D00
	DATA	F$XDR		>0D40
	DATA	F$XLR		>0D80
	DATA	F$XSTR		>0DC0
	DATA	ILLOP		>0E00
	DATA	F$XAD		>0E40
	DATA	F$XCID		>0E80
	DATA	F$XSD		>0EC0
	DATA	F$XMD		>0F00
	DATA	F$XDD		>0F40
	DATA	F$XLD		>0F80
	DATA	F$XSTD		>0FC0
*
* No operand instruction dispatch table.
*
NOOPRD	EQU	$
	DATA	F$XCRI		>0C00
	DATA	F$XCDI		>0C01
	DATA	F$XNGR		>0C02
	DATA	F$XNGD		>0C03
	DATA	F$XCRE		>0C04
	DATA	F$XCDE		>0C05
	DATA	F$XCER		>0C06
	DATA	F$XCED		>0C07
	DATA	ILLOP		>0C08
	DATA	ILLOP		>0C09
	DATA	ILLOP		>0C0A
	DATA	ILLOP		>0C0B
	DATA	ILLOP		>0C0C
	DATA	ILLOP		>0C0D
	DATA	XIT		>0C0E
	DATA	XIT		>0C0F
	END
