/************************************************************************
* stat - Stat a file.
************************************************************************/

#include <stdio.h>
#include <unistd.h>
#include <stdarg.h>
#include <errno.h>
#include <memory.h>
#include <string.h>
#include <time.h>
#include <fcntl.h>
#include <sys/stat.h>
#include <sys/types.h>
#include <dirent.h>
#include <sys/svc.h>

#ifdef DEBUGSTAT
#include "hexdump.h"
#endif

int
stat (const char *path, struct stat *buf)
{
   DIR *dp;
   struct dirent *ep;
   char *fn;
   char *cp;
   int found;
   char temp[MAXPATHNAMESIZE+2];
   char file[DIRSIZ+2];

   if (buf == NULL)
   {
      _errno = EINVAL;
      return (-1);
   }

   memset (buf, 0, sizeof(struct stat));
   _setpath (temp, (char *)path);

   if ((fn = strrchr (&temp[1], '.')) == NULL)
   {
      buf->st_mode = S_IFBLK;
      return (0);
   }
   *fn++ = 0;

   strcpy (file, fn);
   fn = file;
   if (!path[0])
      strcpy (&temp[1], ".VCATALOG");

#ifdef DEBUGSTAT
   printf ("stat: path = %s, temp = %s, fn = %s\n", path, temp, fn);
#endif
   if ((dp = opendir (&temp[1])) == NULL)
   {
      return (-1);
   }
   found = FALSE;
   while ((ep = readdir(dp)) != NULL)
   {
#ifdef DEBUGSTAT
      printf ("   ep->d_name = %s\n", ep->d_name);
#endif
      if (!strcmp (fn, ep->d_name))
      {
	 time_t timeval;
	 unsigned int times[5];

#ifdef DEBUGSTAT
         HEXDUMP (stdout, (char *)&dp->dd_buf, sizeof(dp->dd_buf), 0);
#endif
	 found = TRUE;
	 buf->st_mode = S_IRUSR | S_IRGRP | S_IROTH;
	 if ((ep->d_flags & ATTRUSAGEMASK) == ATTRDIRECTORY)
	 {
#ifdef DEBUGSTAT
            printf ("   Is a directory\n");
#endif
	    buf->st_mode |= S_IFDIR;
	 }
	 else if ((ep->d_flags & ATTRUSAGEMASK) == ATTRPROGRAM)
	 {
#ifdef DEBUGSTAT
            printf ("   Is a program file\n");
#endif
	    buf->st_mode |= S_IFPRG | S_IXUSR | S_IXGRP | S_IXOTH;
	 }
	 else
	 {
#ifdef DEBUGSTAT
            printf ("   Is a regular file\n");
#endif
	    buf->st_mode |= S_IFREG;
	 }
	 if (!(ep->d_flags & ATTRWRITEPROT))
	 {
#ifdef DEBUGSTAT
            printf ("   Allows writes\n");
#endif
	    buf->st_mode |= S_IWUSR | S_IWGRP | S_IWOTH;
	 }
	 buf->st_size = ep->d_size;
	 _dirtime (times,
		   dp->dd_buf.dir.dxdir.d_ayear, dp->dd_buf.dir.dxdir.d_aday,
		   dp->dd_buf.dir.dxdir.d_atime);
#ifdef DEBUGSTAT
         printf ("   times = %d %d %d %d %d\n",
	 	times[0], times[1], times[2], times[3], times[4]);
#endif
	 _stime (times, &timeval);
#ifdef DEBUGSTAT
         printf ("   atime = %lu\n", timeval);
#endif
	 buf->st_atime = timeval;
	 buf->st_mtime = timeval;
	 _dirtime (times,
		   dp->dd_buf.dir.dxdir.d_cyear, dp->dd_buf.dir.dxdir.d_cday,
		   dp->dd_buf.dir.dxdir.d_ctime);
#ifdef DEBUGSTAT
         printf ("   times = %d %d %d %d %d\n",
	 	times[0], times[1], times[2], times[3], times[4]);
#endif
	 _stime (times, &timeval);
#ifdef DEBUGSTAT
         printf ("   ctime = %lu\n", timeval);
#endif
	 buf->st_ctime = timeval;
         break;
      }
   }
   closedir (dp);
   if (!found)
   {
      _errno = ENOENT;
      return (-1);
   }
   return (0);
}
