#include <stdio.h>
#include <unistd.h>
#include <string.h>
#include <errno.h>
#include <fcntl.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <dirent.h>

#ifndef MAXPATHNAMESIZE
#define MAXPATHNAMESIZE 255
#endif

#if !defined(dx10) && !defined(dnos)
#define d_flags d_ino
#endif

int
main(int argc, char **argv)
{
   DIR *dp;
   struct dirent *ep;
   int i;
   
   printf ("%s:\n", argv[0]);

   for (i = 1; i < argc; i++)
   {
      printf ("arg[%d] = %s\n", i, argv[i]);
   }

   if (argc != 2)
   {
      printf ("usage: %s dirname\n", argv[0]);
      return 1;
   }

   if ((dp = opendir (argv[1])) == NULL)
   {
      printf ("opendir failed: error = %s\n", strerror(errno));
      return 1;
   }

   printf ("readdir:\n");
   while ((ep = readdir (dp)) != NULL)
   {
      char fn[MAXPATHNAMESIZE+2];
      struct stat stbuf;
      printf ("   name = %s, flags = >%04X\n", ep->d_name, ep->d_flags);
#if defined(TXDS)
      sprintf (fn, "%s:%s", argv[1], ep->d_name);
#else
      sprintf (fn, "%s.%s", argv[1], ep->d_name);
#endif
      if (stat (fn, &stbuf) < 0)
	 printf ("stat failed: error = %s\n", strerror(errno));
      else
         printf ("   mode = 0%06o, len = %lu\n", stbuf.st_mode, stbuf.st_size);
   }
   if (errno != 0)
      printf ("readdir failed: error = %s\n", strerror(errno));

   printf ("rewind/readdir:\n");
   rewinddir(dp);
   while ((ep = readdir (dp)) != NULL)
   {
      int where = telldir(dp);
      printf ("   name = %s, flags = >%04X, where = %d\n",
      		ep->d_name, ep->d_flags, where);
   }
   if (errno != 0)
      printf ("readdir failed: error = %s\n", strerror(errno));

   printf ("seekdir/readdir:\n");
   seekdir(dp, 0);
   while ((ep = readdir (dp)) != NULL)
   {
      int where = telldir(dp);
      printf ("   name = %s, flags = >%04X, where = %d\n",
      		ep->d_name, ep->d_flags, where);
   }
   if (errno != 0)
      printf ("readdir failed: error = %s\n", strerror(errno));

   closedir (dp);

   return 0;
}
