#include <stdio.h>
#include <unistd.h>
#include <string.h>
#include <errno.h>
#include <fcntl.h>

int
main(int argc, char **argv)
{
   FILE *ifd, *ofd;
   int i, j;
   
   printf ("%s:\n", argv[0]);

   for (i = 1; i < argc; i++)
   {
      printf ("arg[%d] = %s\n", i, argv[i]);
   }

   if (argc != 3)
   {
      printf ("usage: %s filein fileout\n", argv[0]);
      return 1;
   }

   if ((ifd = fopen (argv[1], "r")) == NULL)
   {
      printf ("fopen-r failed: %s: errno = %d\n", argv[1], errno);
      return 1;
   }
   if ((ofd = fopen (argv[2], "w")) == NULL)
   {
      printf ("fopen-w failed: %s: errno = %d\n", argv[2], errno);
      fclose (ifd);
      return 1;
   }

   while ((j = fgetc(ifd)) != EOF)
   {
      fputc (j, ofd);
   }
   if (ferror(ifd))
   {
      printf ("fgetc failed\n");
   }

   fclose (ifd);
   fclose (ofd);

   return 0;
}
